<?php
function debug_local($message) {
  watchdog("hblaw debug",$message ,$variables = array(), $severity = WATCHDOG_NOTICE, $link = NULL);
}
function xhbglaw_my_links($links, $attributes = array('class' => 'links')) {
  //  This function is not currently used
  //debug_local('In hbglaw_links');
  global $language;
  //print "LINKS: <pre>";print_r($links); print "</pre><br>";
  $output = '';
  $query = $_SERVER[REQUEST_URI];
  if (count($links) > 0) {
    //$output = '<ul'. drupal_attributes($attributes) .'>';
    $output = '<div id="navBar">';	
    $num_links = count($links);
    $i = 1;

    foreach ($links as $key => $link) {
      $class = 'menuItem';
      if (isset($link['href'])) {
        $alias= drupal_get_path_alias($link['href']);
        $path_parts = preg_split('@/@',$alias);
        $base_dir = $path_parts[0];
        //print "LINK: <pre>";print_r($link); print "</pre><br>";
        //print "HREF: $alias<br>BASE: $base_dir<br>QUERY: $query<br>";
      }

      if (isset($link['href']) && ((($link['href'] == $query ) || preg_match("/$base_dir/", $query)) || ($link['href'] == '<front>' && drupal_is_front_page()))
          && (empty($link['language']) || $link['language']->language == $language->language)) {
        $class = 'navOn';
      }
      if (isset($link['href'])) {
        // Pass in $link as $options, they share the same keys.
        $output .= l($link['title'], $link['href'], array('attributes' =>  array('class' => $class)));
      }
      else if (!empty($link['title'])) {
        // Some links are actually not links, but we wrap these in <span> for adding title and class attributes
        if (empty($link['html'])) {
          $link['title'] = check_plain($link['title']);
        }
        $span_attributes = '';
        if (isset($link['attributes'])) {
          $span_attributes = drupal_attributes($link['attributes']);
        }
        $output .= '<span'. $span_attributes .'>'. $link['title'] .'</span>';
      }

      $i++;
    }

    $output .= '</div>';
  }
  return $output;
}
/**
 * Implements theme_menu_item_link()
 */
function hbglaw_menu_item_link($link) {
  if (empty($link['localized_options'])) {
    $link['localized_options'] = array();
  }

  // If an item is a LOCAL TASK, render it as a tab
  if ($link['type'] & MENU_IS_LOCAL_TASK) {
    $link['title'] = '<span class="tab">' . check_plain($link['title']) . '</span>';
    $link['localized_options']['html'] = TRUE;
  }

  return l($link['title'], $link['href'], $link['localized_options']);
}

/**
 * Duplicate of theme_menu_local_tasks() but adds clear-block to tabs.
 */
function hbglaw_menu_local_tasks() {
  $output = '';

  // CTools requires a different set of local task functions.
  if (module_exists('ctools')) {
    $primary = ctools_menu_primary_local_tasks();
    $secondary = ctools_menu_secondary_local_tasks();
  }
  else {
    $primary = menu_primary_local_tasks();
    $secondary = menu_secondary_local_tasks();
  }

  if ($primary) {
    $output .= '<ul class="tabs primary clear-block">' . $primary . '</ul>';
  }
  if ($secondary) {
    $output .= '<ul class="tabs secondary clear-block">' . $secondary . '</ul>';
  }

  return $output;
}

/**
* Implementation of MODULENAME/THEMENAME_preprocess_page().
*/
function hbglaw_preprocess_page(&$vars) {
  // if this is a panel page, add template suggestions
  if($panel_page = page_manager_get_current_page()) {
    // add a generic suggestion for all panel pages
    $suggestions[] = 'page-panel';
    // add the panel page machine name to the template suggestions
    $suggestions[] = 'page-' . $panel_page['name'];
    // merge the suggestions in to the existing suggestions (as more specific than the existing suggestions)
    $vars['template_files'] = array_merge($vars['template_files'], $suggestions);
  }
}

function hbglaw_get_treex() {

  $output="";
  $menu=menu_tree_all_data("primary-links",NULL);
  foreach ($menu as $key => $ary) {

    $link = $ary[link];
    $output .= "<br>".$link[title] ."&nbsp;&nbsp;&nbsp;&nbsp;" . $link[link_path];
    if ($ary[below]) {
      $link = $ary[below];
      foreach ($link as $key1 => $subary) {        
        $output.= "<br>&nbsp;&nbsp;&nbsp;&nbsp;". $subary[link][title] ."&nbsp;&nbsp;&nbsp;&nbsp;" . $subary[link][link_path];
      }
    }  
  }
  $output .= "<br>";
  return $output;
}

/**
* Generate menu for primary-links
*/
function hbglaw_get_tree() {
  $output='<table id="tab-menu" align="center" width="100%"><tr><td><div class="menu" id="navBar"><ul id="nav">';
  $query = $_SERVER[REQUEST_URI];
  
  $menu=menu_tree_all_data("primary-links",NULL);
  $link_class=  array(); $link_class[] ="first";
  $n = sizeof($menu); $i = 0;
  foreach ($menu as $key => $ary) {
    $i = $i + 1;
    if ($i == $n ) { $link_class[] ="last"; }
    $link = $ary['link'];
    
    $alias= drupal_get_path_alias($link['href']);
    $path_parts = preg_split('@/@',$alias);
    $base_dir = $path_parts[0];

    $class= ((($link['href'] == $query ) || preg_match("/$base_dir/", $query)) || ($link['href'] == '<front>' && drupal_is_front_page())) ? "navOn" : "menuItem";
    if ($ary['below']) { $link_class[] = "down"; }

    $output .= "<li";
    $output .=  $link_class[0] ? ' class = "'.join(" ",$link_class).'"' : "";
    $output .= ">";
    $link_class = array();
    $output .= l($link['title'], $link['href'], array('attributes' =>  array('class' => $class)));

    if ($ary['below']) {
      $link = $ary['below'];
      $output .= '<ul>';
        
      foreach ($link as $key1 => $subary) {
          $output .= '<li>';
        $output .= l($subary['link']['title'], $subary['link']['href'], array('attributes' =>  array()));
        $output.= "</li>";
      }
      $output .= '</ul>';
    }  
    $output.= "</li>";
  }
  $output .= "</ul></div></td></tr></table>";
  return $output;
}

/**
* Theme function for subNav blocks
*/
function hbglaw_blocks($region) {
  $query = $_SERVER[REQUEST_URI];
  $output='';
  if ($list = block_list($region)) {
    foreach ($list as $key => $block) {
      if ($region == "left") {
        $lines = preg_split('@\n@',$block->content);
        $process =   preg_match("@class=\"subNav\"@", $lines[0]);
        $links = preg_split('@</a>@',$lines[1]);
        $links = preg_replace('@^\s+@','',$links);
        if ($process) { 
          foreach ($links as $linkk => $link) {
            $page = preg_replace('@.*href="@','',$link);
            $page = preg_replace('@".*@','',$page);
            if( preg_match("@$page@",$query) ) {
              $links[$linkk]=preg_replace('/subNav/','subNav active',$links[$linkk]);
            }
          }
          $my_content = join("</a>",$links);
          $my_content = '<div class="subnav-block">' . $my_content . '</div>';
          $block->content = $my_content;
        }
      }
      $output .= theme('block', $block);
    }
  }
  
  return $output;
  
  //$menu=menu_tree_all_data("primary-links",NULL);

}
