
 <?
/*
 * PHP Freaks Code Library
 * http://www.phpfreaks.com/quickcode.php
 *
 * Title: Dblib 1.2
 * Version: 1.0
 * Author: Vladimir Gorej aka(char0n)
 * Date: Friday, 12/23/2005 - 05:40 AM
 *
 *
 *
 * NOTICE: This code is available from PHPFreaks.com code Library.
 *         This code is not Copyrighted by PHP Freaks.
 *
 *         PHP Freaks does not claim authorship of this code.
 *
 *         This code was submitted to our website by a user.
 *
 *         The user may or may not claim authorship of this code.
 *
 *         If there are any questions about the origin of this code,
 *         please contact the person who submitted it, not PHPFreaks.com!
 *
 *         USE THIS CODE AT YOUR OWN RISK! NO GUARANTEES ARE GIVEN!
 *
 * SHAMELESS PLUG: Need WebHosting? Checkout WebHost Freaks:
 *                 http://www.webhostfreaks.com
 *                 WebHosting by PHP Freaks / The Web Freaks!
*/


// *    Description / Example:
// *
// *    This is the database class i wrote to make my work with databases comfortable and reduce the code size of my scripts. The class is called simply DbLib. You can support different dbs by writing a new derived classes. Since there is only MySQL support. Feel free to write new dbs extensions for it.

?>

<?php
/*! @class	Sql Library Class version 1.2 (later just DbLib)
    @author	char0n (May 11 2005)
    @abstract	DbLib for operating actions with Sql databases
    @discussion	DbLib can be easily extended and used for many dbs

    @licence	GNU General Public Licence, Version 2, june 1991
    		This program is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY
		You should have received a copy of the GNU General Public License
		along with this program
*/

///////////////////////////////////////////////////////////////////////////////
// DbLib base class defines the basic operations. You can support
// different dbs by writing a new derived class

class DbLib
{

    var		$mHost		= 'localhost';
    var		$mPort		=  3306;
    var		$mUser		= 'hbgleg';
    var		$mPassword	= 'hbglegX1';
    var		$mDatabase	= 'hbgleg';
    var     $defcharset = 'latin1';
    var		$mSocket;
    var		$mResult;
    var		$mRow;
    /*
    var		$mHost		= 'mysql5a.appliedi.net';
    var		$mPort		=  3306;
    var		$mUser		= 'heimberglaw';
    var		$mPassword	= 'medmal123';
    var		$mDatabase	= 'heimberglaw';
    var     $defcharset = 'latin1';
    var		$mSocket;
    var		$mResult;
    var		$mRow;
    */

    function OpenConnection()	{	$this->mSocket  =  1;		}
    function SelectDatabase()	{	$this->IsConnected();		}
    function DbQuery()		{	$this->IsConnected();		}
    function Query()		{	$this->IsConnected();		}
    function GetResult()	{	$this->IsConnected();		}
    function GetNumRows()	{	$this->IsConnected();		}
    function GetNextRecord()	{	$this->IsConnected();		}
    function GetField()		{	$this->IsConnected();		}
    function FreeResult()	{	$this->IsConnected();		}
    function GetAffectedRows()	{	$this->IsConnected();		}
    function GetLastID()	{	$this->IsConnected();		}
    function CloseConnection()	{	$this->IsConnected();		}
    function GetError()		{	$this->IsConnected();		}
    function SqlCorrection() 	{       $this->IsConnected();		}
    function __wakeup()		{	$this->OpenConnection();	}
    function __sleep()		{	$this->CloseConnection();	}
    function ResetRecordSet() {	$this->IsConnected();		}
    function IsConnected()
    {
	if (!$this->mSocket) die('Not connected to database server');
    }

}

///////////////////////////////////////////////////////////////////////////////
// MySQL database support
class DbLibMySQL extends DbLib
{

    function DbLibMySQL($host = 0, $port = 0, $user = 0, $password = 0, $database = 0)
    {
	if ($host)      $this->mHost      = $host;
	if ($port)      $this->mPort      = $port;
	if ($user)      $this->mUser      = $user;
	if ($password)  $this->mPassword  = $password;
	if ($database)  $this->mDatabase  = $database;
    }


    function OpenConnection()
    {
	parent::OpenConnection();
	$this->mSocket = @mysql_connect($this->mHost . ':' . $this->mPort, $this->mUser, $this->mPassword)
	    or die($this->GetError());
	@mysql_select_db($this->mDatabase,$this->mSocket)
	    or die($this->GetError());
	//$this->DbQuery(\"SET NAMES '{$this->DefCharset}'");
	return $this->mSocket;
    }


    function SelectDatabase($database = '')
    {
	parent::SelectDatabase();
	@mysql_select_db($database,$this->mSocket) or die($this->GetError());
	$this->mDatabase = $database;
    }


    function DbQuery($query = '')
    {
	parent::DbQuery();
	@mysql_unbuffered_query($query,$this->mSocket) or die($this->GetError());
    }


    function Query($query = '')
    {
	parent::Query();
	($this->mResult = @mysql_query($query,$this->mSocket)) or die($this->GetError());
	return $this->mResult;
    }


    function GetResult($row = 0, $coll = 0, $result = 0)
    {
	parent::GetResult();
	($result) ? $temp_result = $result : $temp_result = $this->mResult;

	if (!is_resource($temp_result)) 	      die('Not MySQL resource while getting results');
	return @mysql_result($temp_result,$row,$coll);
    }


    function GetNumRows($result = 0)
    {
	parent::GetNumRows();
	($result) ? $temp_result = $result : $temp_result = $this->mResult;

	if (!is_resource($temp_result)) 	      die('Not MySQL resource while getting results');
	return @mysql_num_rows($temp_result);
    }

    function GetAffectedRows()
    {
	parent::GetAffectedRows();
	return @mysql_affected_rows($this->mSocket);
    }

    function GetLastID()
    {
	parent::GetLastID();
	return @mysql_insert_id($this->mSocket);
    }

    function GetNextRecord($result = 0)
    {
	parent::GetNextRecord();
	($result) ? $temp_result = $result : $temp_result = $this->mResult;

	if (!is_resource($temp_result)) 	      die('Not MySQL resource while getting results');

        $this->mRow = @mysql_fetch_assoc($temp_result);
        return $this->mRow != FALSE;
    }

    function GetField($field = '')
    {
	parent::GetField();
        return $this->mRow[$field];
    }


    function FreeResult($result = 0)
    {
	parent::FreeResult();
	if ($result) $temp_result = $result;
	else 	     $temp_result = $this->mResult;

	if (!is_resource($temp_result))   	      die('Not MySQL resource while freeing results');
	@mysql_free_result($temp_result);
    }


    function SqlCorrection($string)
    {
	parent::SqlCorrection();
	return @mysql_real_escape_string($string);
    }


    function GetError()
    {
	parent::GetError();
	return @mysql_error();
    }


    function CloseConnection()
    {
	parent::CloseConnection();
	@mysql_close($this->mSocket) or die('There is no valid MySQL-Link resource');
    }

	function ResetRecordSet()
	{
	parent::ResetRecordSet();
	@mysql_data_seek($this->mResult, 0);
	}

}
?>
