<?php
/* $Id: forward.tpl.php,v 1.1.2.9 2010/08/30 19:59:34 seanr Exp $ */

/**
 * This template should only contain the contents of the body
 * of the email, what would be inside of the body tags, and not
 * the header.  You should use tables for layout since Microsoft
 * actually regressed Outlook 2007 to not supporting CSS layout.
 * All styles should be inline.
 *
 * For more information, consult this page:
 * http://www.anandgraves.com/html-email-guide#effective_layout
 *
 * If you are upgrading from an old version of Forward, be sure
 * to visit the Forward settings page to enable use of the new
 * template system.
 */
?>
<?php if($forward_plaintext) : ?>
This is a multi-part message in MIME format.

--NextMime00A_000_893263890D
Content-Type: text/plain; charset="utf-8"
Content-Transfer-Encoding: 8Bit';

<?php
  function forward_clean($str) {
    $str = preg_replace("/<([^>]+)>/","",$str);
    $str = preg_replace("/&amp;/","&",$str);
    $str = preg_replace("/&nbsp;/"," ",$str);
    $str = preg_replace("/&rsquo;/","'",$str);
    $str = preg_replace("/&lsquo;/","`",$str);
    $str = preg_replace("/\t*/","",$str);
    $str = preg_replace("/^\s+/","",$str);
    return $str;
  }
  // plain text portion
  print forward_clean($forward_message);
  if ($message) { 
  	print "\n" . t("$name also sent you the following message:") . "\n====================================================\n";
    print forward_clean($message) . "\n";
    print "====================================================";
  }
  $title = forward_clean($title);
  print "\n\n$title\n\n";   
  print preg_replace("/\s+$/", "",forward_clean($teaser));
  print "\n\nFor more information, Click here or paste this link into your browser:\n$site_url\n\n";

  if ($forward_ad_footer) {
    $text = forward_clean($forward_ad_footer);
    if ($text) { print $text . "\n"; }
  }
  if ($forward_footer) {
    $text = forward_clean($forward_footer);
    if ($text) { print $text . "\n"; }
  }

  print variable_get('site_name', '') . "\n\n";
  print variable_get('site_slogan', '') . "\n\n";

?>

--NextMime00A_000_893263890D
Content-Type: text/html;   charset="utf-8"
Content-Transfer-Encoding: 8Bit

<?php endif  ?>
<table width="<?php print $width; ?>" cellspacing="0" cellpadding="10" border="0">
  <thead> <tr> <td align="center">
      <h1 style="font-family:Arial,Helvetica,sans-serif; font-size:18px;"><a href="<?php print $site_url; ?>"
         style="text-decoration: none;" title="<?php print variable_get('site_name', ''); ?>"><?php print $logo; ?></a></h1>
      </td></tr>
  </thead>
  <tbody>
    <tr>
      <td style="font-family:Arial,Helvetica,sans-serif; font-size:14px;">
         <table style="border: 3px solid #1D493C; margin: 0px 10px 0px 10px;" >
            <tr><td>
         <div style="width: 100%; padding: 5px 0px; text-align: center; background-color: #eee; line-height: 14px; border-bottom: 1px solid #1D493C;"><?php print $forward_message; ?></div> </td></tr>
        <?php if ($message) : ?>
         <tr><td style=" padding: 5px 10px; text-align: left; background-color: #eee; line-height: 20px; border-bottom: 1px solid #1D493C;"><?php print t("Message from:  $name"); ?></td></tr>

         <tr><td style="padding: 5px 10px; background-color: #eee; line-height: 20px; border-bottom: 1px solid #1D493C;"><?php print $message; ?></div></td></tr>
        <?php endif ?>
          &nbsp;<br />  
       <tr><td> <?php if ($title) : ?>
            <h2 style="font-size: 14px;"><a href="<?php print $site_url; ?>">
               <?php print $title; ?></a></h2>
        <?php endif ?>
        <?php if ($submitted) : ?>
            <p><em><?php print $submitted; ?></em></p>
        <?php endif ?>
        <?php if ($teaser) : ?>
          <div><?php print $teaser; ?></div>
        <?php endif ?>
        <p><?php print $link; ?></p>
        &nbsp;
      </td></tr></table>
    </tr>
      <?php if ($dynamic_content) : ?>
      <tr><td style="font-family:Arial,Helvetica,sans-serif; font-size:14px;">
        <?php print $dynamic_content; ?>
      </td>
    </tr><?php endif ?>
    <?php if ($forward_ad_footer) : ?><tr>
      <td style="font-family:Arial,Helvetica,sans-serif; font-size:14px;">
        <?php print $forward_ad_footer; ?>
      </td>
    </tr><?php endif ?>
    <?php if ($forward_footer) : ?><tr>
      <td style="height: 104px; font-family:Arial,Helvetica,sans-serif; font-size:18px;">
        <?php print $forward_footer; ?>
      </td>
    </tr><?php endif ?>
  </tbody>
</table>      
<?php if($forward_plaintext) : ?>
--NextMime00A_000_893263890D--
<?php endif ?>
