<?php
// $Id: admin.settings.inc,v 1.3 2009/11/26 15:13:51 dww Exp $

/**
 * @file
 * Code required for the admin/project/project-release-settings page.
 */

/**
 * Build the form for the project_release settings administration page.
 */
function project_release_settings_form() {
  if ($rel_dir = variable_get('project_release_directory', '')) {
    $form['project_release_directory'] = array(
      '#type' => 'textfield',
      '#title' => t('Release directory'),
      '#default_value' => $rel_dir,
      '#size' => 50,
      '#maxlength' => 255,
      '#description' => t('This setting has been temporarily deprecated. If your site depends on scanning for releases generated by an external tool, you should wait to upgrade until a future version of the project_release.module is available that restores this functionality. Set the value blank to acknowlege that you do not need this behavior, and this error will disappear.'),
    );
  }
  $form['project_release_default_version_format'] = array(
    '#type' => 'textfield',
    '#title' => t('Default version format string'),
    '#default_value' => variable_get('project_release_default_version_format', PROJECT_RELEASE_DEFAULT_VERSION_FORMAT),
    '#size' => 50,
    '#maxlength' => 255,
    '#description' => t('Customize the default format of the version strings for releases of projects on this site. Users with "administer projects" permissions can override this setting for each project.') .' '. PROJECT_RELEASE_VERSION_FORMAT_HELP,
  );

  $form['project_release_file_extensions'] = array(
    '#type' => 'textfield',
    '#title' => t('Permitted file extensions'),
    '#default_value' => variable_get('project_release_file_extensions', PROJECT_RELEASE_FILE_EXTENSIONS),
    '#size' => 50,
    '#maxlength' => 255,
    '#description' => t('Files uploaded to release nodes will only be allowed if they have an extension that is included in this list.'),
  );

  if ($tree = project_release_get_api_taxonomy()) {
    foreach ($tree as $term) {
      $terms[$term->tid] = check_plain($term->name);
    }
    $vocab = taxonomy_vocabulary_load(_project_release_get_api_vid());
    $tids = variable_get('project_release_active_compatibility_tids', array());
    $form['project_release_active_compatibility_tids'] = array(
      '#type' => 'checkboxes',
      '#title' => t('Active @vocab terms', array('@vocab' => $vocab->name)),
      '#default_value' => $tids,
      '#options' => $terms,
      '#description' => t('Terms from the %vocab vocabulary that should be visibile to end users and project maintainers.', array('%vocab' => $vocab->name)),
    );

    // TODO: put these 2 in a fieldset?
    // @TODO:  For D6 port, this setting can be deleted.
    $terms = array(-1 => t('all')) + $terms;
    $form['project_release_browse_versions'] = array(
      '#type' => 'checkbox',
      '#title' => t('Browse projects by release versions'),
      '#default_value' => variable_get('project_release_browse_versions', 0),
      '#description' => t('Checking this box will cause the project browsing page to have a version select.'),
    );
    $form['project_release_overview'] = array(
      '#type' => 'radios',
      '#title' => t('Default release overview'),
      '#default_value' => variable_get('project_release_overview', -1),
      '#options' => $terms,
      '#required' => TRUE,
      '#description' => t('Default release version to list on the overview page.'),
    );
  }
  $form['project_release_download_base'] = array(
    '#type' => 'textfield',
    '#title' => t('Download link base URL'),
    '#default_value' => variable_get('project_release_download_base', ''),
    '#size' => 50,
    '#maxlength' => 255,
    '#description' => t("By default, all download links to releases will use the standard download path for the site. However, if you wish to host the downloads at a different location, you can specify the base of the URL that should be used for download links. For example, if you stored releases in %files_path and you want to have download links pointing to %ftp_url, you would set this to %ftp_setting. Note that if you define this, the value should end with a slash ('/').", array('%files_path' => 'files/projects/foo.tar.gz', '%ftp_url' => 'ftp://ftp.example.com/files/projects/foo.tar.gz', '%ftp_setting' => 'ftp://ftp.example.com/')),
  );
  return system_settings_form($form);
}

/**
 * Validation callback for the project_release settings form.
 */
function project_release_settings_form_validate($form, &$form_state) {
  if (!empty($form_state['values']['project_release_directory'])) {
    form_set_error('project_release_directory', t('Release directory setting has been deprecated.'));
  }
  // Only validate these form elements if the API compatibility form elements
  // were even added to the form to avoid PHP notices when there are no terms
  // in the API compatibility vocabulary.
  if (isset($form_state['values']['project_release_active_compatibility_tids'])) {
    $tids = $form_state['values']['project_release_active_compatibility_tids'];
    $default_tid = $form_state['values']['project_release_overview'];
    if ($default_tid != -1 && !$tids[$default_tid]) {
      $vocab = taxonomy_vocabulary_load(_project_release_get_api_vid());
      form_set_error('project_release_overview', t('Project release overview must be one of the active %vocab terms.', array('%vocab' => $vocab->name)));
    }
  }

  // Make sure the default version format has no bad characters.
  _project_release_validate_format_string($form_state['values'], 'project_release_default_version_format');

  // If set, the project_release_download_base must end with a '/'
  if (!empty($form_state['values']['project_release_download_base'])) {
    if (substr($form_state['values']['project_release_download_base'], -1) != '/') {
       form_set_error('project_release_download_base', t('The <em>Download link base URL</em> should end with a slash.'));
    }
  }
}

