/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.util.AccumulativeRunnable;
import org.jdesktop.swingx.util.SwingPropertyChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SwingWorker<T, V>
implements Future<T>,
Runnable {
    private static final int MAX_WORKER_THREADS = 10;
    private volatile int progress;
    private volatile StateValue state;
    private final FutureTask<T> future;
    private final SwingPropertyChangeSupport propertyChangeSupport;
    private AccumulativeRunnable<V> doProcess;
    private AccumulativeRunnable<Integer> doNotifyProgressChange;
    private static ExecutorService executorService = null;

    public SwingWorker() {
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                SwingWorker.this.setState(StateValue.STARTED);
                return SwingWorker.this.doInBackground();
            }
        };
        this.future = new FutureTask<T>(callable){

            @Override
            protected void done() {
                SwingWorker.this.doneEDT();
                SwingWorker.this.setState(StateValue.DONE);
            }
        };
        this.state = StateValue.PENDING;
        this.propertyChangeSupport = new SwingPropertyChangeSupport(this, true);
        this.doProcess = null;
        this.doNotifyProgressChange = null;
    }

    protected abstract T doInBackground() throws Exception;

    @Override
    public final void run() {
        this.future.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void publish(V ... chunks) {
        SwingWorker swingWorker = this;
        synchronized (swingWorker) {
            if (this.doProcess == null) {
                this.doProcess = new AccumulativeRunnable<V>(){

                    @Override
                    public void run(V ... args) {
                        SwingWorker.this.process(args);
                    }
                };
            }
        }
        this.doProcess.add(chunks);
    }

    protected void process(V ... chunks) {
    }

    protected void done() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setProgress(int progress) {
        if (progress < 0 || progress > 100) {
            throw new IllegalArgumentException("the value should be from 0 to 100");
        }
        int oldProgress = this.progress;
        this.progress = progress;
        SwingWorker swingWorker = this;
        synchronized (swingWorker) {
            if (this.doNotifyProgressChange == null) {
                this.doNotifyProgressChange = new AccumulativeRunnable<Integer>(){

                    public void run(Integer ... args) {
                        SwingWorker.this.firePropertyChange("progress", args[0], args[args.length - 1]);
                    }
                };
            }
        }
        if (oldProgress != progress) {
            this.doNotifyProgressChange.add((Integer[])new Integer[]{oldProgress, progress});
        }
    }

    public final int getProgress() {
        return this.progress;
    }

    public final void execute() {
        SwingWorker.getWorkersExecutorService().execute(this);
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public final boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public final T get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public final T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(listener);
    }

    public final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.getPropertyChangeSupport().firePropertyChange(propertyName, oldValue, newValue);
    }

    public final PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public final StateValue getState() {
        if (this.isDone()) {
            return StateValue.DONE;
        }
        return this.state;
    }

    private void setState(StateValue state) {
        StateValue old = this.state;
        this.state = state;
        this.firePropertyChange("state", (Object)old, (Object)state);
    }

    private void doneEDT() {
        Runnable doDone = new Runnable(){

            public void run() {
                SwingWorker.this.done();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            doDone.run();
        } else {
            SwingUtilities.invokeLater(doDone);
        }
    }

    private static synchronized ExecutorService getWorkersExecutorService() {
        if (executorService == null) {
            ThreadFactory threadFactory = new ThreadFactory(){
                final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

                public Thread newThread(Runnable r) {
                    Thread thread = this.defaultFactory.newThread(r);
                    thread.setName("SwingWorker-" + thread.getName());
                    thread.setPriority(1);
                    return thread;
                }
            };
            executorService = new ThreadPoolExecutor(0, 10, 1L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue(), threadFactory){
                private final ReentrantLock pauseLock = new ReentrantLock();
                private final Condition unpaused = this.pauseLock.newCondition();
                private boolean isPaused = false;
                private final ReentrantLock executeLock = new ReentrantLock();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(Runnable command) {
                    this.executeLock.lock();
                    try {
                        this.pauseLock.lock();
                        try {
                            this.isPaused = true;
                        }
                        finally {
                            this.pauseLock.unlock();
                        }
                        this.setCorePoolSize(10);
                        super.execute(command);
                        this.setCorePoolSize(0);
                        this.pauseLock.lock();
                        try {
                            this.isPaused = false;
                            this.unpaused.signalAll();
                        }
                        finally {
                            this.pauseLock.unlock();
                        }
                    }
                    finally {
                        this.executeLock.unlock();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void afterExecute(Runnable r, Throwable t) {
                    super.afterExecute(r, t);
                    this.pauseLock.lock();
                    try {
                        while (this.isPaused) {
                            this.unpaused.await();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        this.pauseLock.unlock();
                    }
                }
            };
        }
        return executorService;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StateValue {
        PENDING,
        STARTED,
        DONE;

    }
}

