/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.Scrollable;
import org.jdesktop.swingx.RepaintManagerX;
import org.jdesktop.swingx.TranslucentRepaintManager;
import org.jdesktop.swingx.painter.Painter;

public class JXPanel
extends JPanel
implements Scrollable {
    private boolean scrollableTracksViewportHeight;
    private boolean scrollableTracksViewportWidth;
    private float alpha = 1.0f;
    private boolean oldOpaque;
    private boolean inheritAlpha = true;
    private boolean drawGradient = false;
    private boolean gradientTrackWidth = true;
    private boolean gradientTrackHeight = true;
    private GradientPaint gradientPaint;
    private Painter backgroundPainter;
    private Dimension oldSize;
    private BufferedImage cachedGradient;

    public JXPanel() {
    }

    public JXPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public JXPanel(LayoutManager layout) {
        super(layout);
    }

    public JXPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public void setAlpha(float alpha) {
        if (this.alpha != alpha) {
            assert (alpha >= 0.0f && (double)alpha <= 1.0);
            float oldAlpha = this.alpha;
            this.alpha = alpha;
            if (alpha > 0.0f && alpha < 1.0f) {
                if (oldAlpha == 1.0f) {
                    this.oldOpaque = this.isOpaque();
                    this.setOpaque(false);
                }
                RepaintManager manager = RepaintManager.currentManager(this);
                try {
                    if (!manager.getClass().isAnnotationPresent(TranslucentRepaintManager.class)) {
                        RepaintManager.setCurrentManager((RepaintManager)new RepaintManagerX());
                    }
                }
                catch (SecurityException e) {
                    RepaintManager.setCurrentManager((RepaintManager)new RepaintManagerX());
                }
            } else if (alpha == 1.0f && this.oldOpaque) {
                this.setOpaque(true);
            }
            this.firePropertyChange("alpha", oldAlpha, alpha);
            this.repaint();
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    public float getEffectiveAlpha() {
        if (this.inheritAlpha) {
            float a = this.alpha;
            Container c = this;
            while ((c = c.getParent()) != null) {
                if (!(c instanceof JXPanel)) continue;
                a = Math.min(((JXPanel)c).getAlpha(), a);
            }
            return a;
        }
        return this.alpha;
    }

    public boolean isInheritAlpha() {
        return this.inheritAlpha;
    }

    public void setInheritAlpha(boolean val) {
        if (this.inheritAlpha != val) {
            this.inheritAlpha = val;
            this.firePropertyChange("inheritAlpha", !this.inheritAlpha, this.inheritAlpha);
        }
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.scrollableTracksViewportHeight;
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.scrollableTracksViewportWidth;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    public void setScrollableTracksViewportHeight(boolean scrollableTracksViewportHeight) {
        this.scrollableTracksViewportHeight = scrollableTracksViewportHeight;
    }

    public void setScrollableTracksViewportWidth(boolean scrollableTracksViewportWidth) {
        this.scrollableTracksViewportWidth = scrollableTracksViewportWidth;
    }

    public void setGradientPaint(GradientPaint paint) {
        GradientPaint oldPaint = this.gradientPaint;
        this.gradientPaint = paint;
        this.firePropertyChange("gradientPaint", oldPaint, paint);
        this.repaint();
    }

    public GradientPaint getGradientPaint() {
        return this.gradientPaint;
    }

    public void setDrawGradient(boolean b) {
        if (this.drawGradient != b) {
            boolean old = this.drawGradient;
            this.drawGradient = b;
            this.oldSize = this.getSize();
            this.firePropertyChange("drawGradient", old, b);
            this.repaint();
        }
    }

    public boolean isDrawGradient() {
        return this.drawGradient;
    }

    public void setGradientTrackWidth(boolean b) {
        if (this.gradientTrackWidth != b) {
            boolean old = this.gradientTrackWidth;
            this.gradientTrackWidth = b;
            this.firePropertyChange("gradientTrackWidth", old, b);
            this.repaint();
        }
    }

    public boolean isGradientTrackWidth() {
        return this.gradientTrackWidth;
    }

    public void setGradientTrackHeight(boolean b) {
        if (this.gradientTrackHeight != b) {
            boolean old = this.gradientTrackHeight;
            this.gradientTrackHeight = b;
            this.firePropertyChange("gradientTrackHeight", old, b);
            this.repaint();
        }
    }

    public boolean isGradientTrackHeight() {
        return this.gradientTrackHeight;
    }

    public void setBackgroundPainter(Painter p) {
        Painter old = this.getBackgroundPainter();
        this.backgroundPainter = p;
        if (p != null) {
            this.setOpaque(false);
        }
        this.firePropertyChange("backgroundPainter", old, this.getBackgroundPainter());
        this.repaint();
    }

    public Painter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Composite oldComp = g2d.getComposite();
        float alpha = this.getEffectiveAlpha();
        AlphaComposite alphaComp = AlphaComposite.getInstance(3, alpha);
        g2d.setComposite(alphaComp);
        super.paint(g2d);
        g2d.setComposite(oldComp);
    }

    protected void paintComponent(Graphics g) {
        if (this.backgroundPainter != null) {
            this.backgroundPainter.paint((Graphics2D)g, this);
        } else {
            super.paintComponent(g);
            if (this.drawGradient) {
                Insets insets = this.getInsets();
                int width = this.getWidth() - insets.right - insets.left;
                int height = this.getHeight() - insets.top - insets.bottom;
                if (this.gradientPaint == null || this.oldSize == null || this.oldSize.width != width || this.oldSize.height != height) {
                    Color c1 = null;
                    Color c2 = null;
                    if (this.gradientPaint == null) {
                        c1 = this.getBackground();
                        c2 = new Color(c1.getRed() - 40, c1.getGreen() - 40, c1.getBlue() - 40);
                        float x1 = 0.0f;
                        float y1 = 0.0f;
                        float x2 = width;
                        float y2 = 0.0f;
                        boolean cyclic = false;
                        this.gradientPaint = new GradientPaint(x1, y1, c1, x2, y2, c2, cyclic);
                    } else {
                        GradientPaint gp = this.gradientPaint;
                        float x2 = (float)gp.getPoint2().getX();
                        if (this.gradientTrackWidth) {
                            float ratio = (float)width / (float)this.oldSize.width;
                            x2 = (float)gp.getPoint2().getX() * ratio;
                        }
                        float y2 = (float)gp.getPoint2().getY();
                        if (this.gradientTrackHeight) {
                            float ratio = (float)height / (float)this.oldSize.height;
                            y2 = (float)gp.getPoint2().getY() * ratio;
                        }
                        this.gradientPaint = new GradientPaint((float)gp.getPoint1().getX(), (float)gp.getPoint1().getY(), gp.getColor1(), x2, y2, gp.getColor2(), gp.isCyclic());
                    }
                    this.oldSize = new Dimension(width, height);
                    this.cachedGradient = new BufferedImage(width, height, 2);
                    Graphics2D imgg = (Graphics2D)this.cachedGradient.getGraphics();
                    imgg.setPaint(this.gradientPaint);
                    imgg.fillRect(0, 0, width, height);
                }
                Graphics2D g2 = (Graphics2D)g;
                g2.drawImage(this.cachedGradient, null, insets.left, insets.top);
            }
        }
    }
}

