/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer;

import java.awt.EventQueue;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URL;
import java.util.Comparator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.mapviewer.TilePoint;
import org.jdesktop.swingx.util.PaintUtils;

public class Tile
extends AbstractBean {
    private Priority priority = Priority.High;
    private static final Logger LOG = Logger.getLogger(Tile.class.getName());
    private static BlockingQueue<Tile> tileQueue;
    private static ExecutorService service;
    private Throwable error;
    private String url;
    private boolean dummy = false;
    private boolean loaded = false;
    private int zoom;
    private TilePoint location;
    private SoftReference<BufferedImage> image = new SoftReference<Object>(null);
    private PropertyChangeListener uniqueListener = null;

    public Tile(TilePoint location, int zoom) {
        this.loaded = false;
        this.dummy = true;
        this.location = location;
        this.zoom = zoom;
    }

    public Tile(TilePoint location, int zoom, String url, Priority priority) {
        this.url = url;
        this.loaded = false;
        this.location = location;
        this.zoom = zoom;
        this.priority = priority;
        this.startLoading();
    }

    public synchronized boolean isLoaded() {
        return this.loaded;
    }

    private synchronized void setLoaded(boolean loaded) {
        boolean old = this.isLoaded();
        this.loaded = loaded;
        this.firePropertyChange("loaded", old, this.isLoaded());
    }

    public Throwable getUnrecoverableError() {
        return this.error;
    }

    public Throwable getLoadingError() {
        return this.error;
    }

    public BufferedImage getImage() {
        BufferedImage img = this.image.get();
        if (img == null) {
            this.setLoaded(false);
            this.startLoading();
        }
        return img;
    }

    public boolean isDummy() {
        return this.dummy;
    }

    public TilePoint getLocation() {
        return this.location;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void addUniquePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.uniqueListener != null && this.uniqueListener != listener) {
            this.removePropertyChangeListener(propertyName, this.uniqueListener);
        }
        if (this.uniqueListener != listener) {
            this.uniqueListener = listener;
            this.addPropertyChangeListener(propertyName, this.uniqueListener);
        }
    }

    private void startLoading() {
        try {
            tileQueue.put(this);
            service.submit(new TileRunner());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void firePropertyChangeOnEDT(final String propertyName, final Object oldValue, final Object newValue) {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Tile.this.firePropertyChange(propertyName, oldValue, newValue);
                }
            });
        }
    }

    public Priority getPriority() {
        return this.priority;
    }

    public synchronized void promote() {
        if (tileQueue.contains((Object)this)) {
            try {
                tileQueue.remove((Object)this);
                this.priority = Priority.High;
                tileQueue.put(this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    static {
        LOG.setLevel(Level.OFF);
        tileQueue = new PriorityBlockingQueue<Tile>(5, new Comparator<Tile>(){

            @Override
            public int compare(Tile o1, Tile o2) {
                if (o1.getPriority() == Priority.Low && o2.getPriority() == Priority.High) {
                    return 1;
                }
                if (o1.getPriority() == Priority.High && o2.getPriority() == Priority.Low) {
                    return -1;
                }
                return 0;
            }

            @Override
            public boolean equals(Object obj) {
                return obj == this;
            }
        });
        service = Executors.newFixedThreadPool(8, new ThreadFactory(){
            private int count = 0;

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "tile-pool-" + this.count++);
                t.setPriority(1);
                t.setDaemon(true);
                return t;
            }
        });
    }

    static class TileRunner
    implements Runnable {
        TileRunner() {
        }

        public void run() {
            System.out.println("loading");
            final Tile tile = (Tile)((Object)tileQueue.remove());
            int trys = 3;
            while (!tile.isLoaded() && trys > 0) {
                try {
                    URI uri = new URI(tile.url);
                    System.out.println("loading: " + uri);
                    final BufferedImage img = PaintUtils.loadCompatibleImage((URL)uri.toURL());
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            tile.image = new SoftReference<BufferedImage>(img);
                            tile.setLoaded(true);
                        }
                    });
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "Failed to load a tile at url: " + tile.url + ", retrying", e);
                    Throwable oldError = tile.error;
                    tile.error = e;
                    tile.firePropertyChangeOnEDT("loadingError", oldError, tile.error);
                    if (trys == 0) {
                        tile.firePropertyChangeOnEDT("unrecoverableError", null, tile.error);
                        continue;
                    }
                    --trys;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        High,
        Low;

    }
}

