/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.TilePoint;
import org.jdesktop.swingx.mapviewer.TileProviderInfo;

public final class GeoUtil {
    public static TilePoint getTileCoordinate(Point2D pixelCoordinate, TileProviderInfo info) {
        int x = (int)Math.floor(pixelCoordinate.getX() / (double)info.getTileSize());
        int y = (int)Math.floor(pixelCoordinate.getY() / (double)info.getTileSize());
        return new TilePoint(x, y);
    }

    public static Dimension getMapSize(int zoom, TileProviderInfo info) {
        return new Dimension(info.getMapWidthInTilesAtZoom(zoom), info.getMapWidthInTilesAtZoom(zoom));
    }

    public static TilePoint getTileCoordinate(double latitude, double longitude, int zoomLevel, TileProviderInfo info) {
        return GeoUtil.getTileCoordinate(GeoUtil.getBitmapCoordinate(latitude, longitude, zoomLevel, info), info);
    }

    public static boolean isValidTile(TilePoint coord, int zoomLevel, TileProviderInfo info) {
        int x = coord.getX();
        int y = coord.getY();
        if (x < 0 || y < 0) {
            return false;
        }
        if (info.getMapCenterInPixelsAtZoom(zoomLevel).getX() * 2.0 <= (double)(x * info.getTileSize())) {
            return false;
        }
        if (info.getMapCenterInPixelsAtZoom(zoomLevel).getY() * 2.0 <= (double)(y * info.getTileSize())) {
            return false;
        }
        return zoomLevel >= info.getMinimumZoomLevel() && zoomLevel <= info.getMaximumZoomLevel();
    }

    public static Point2D getBitmapCoordinate(GeoPosition c, int zoomLevel, TileProviderInfo info) {
        return GeoUtil.getBitmapCoordinate(c.getLatitude(), c.getLongitude(), zoomLevel, info);
    }

    public static Point2D getBitmapCoordinate(double latitude, double longitude, int zoomLevel, TileProviderInfo info) {
        double x = info.getMapCenterInPixelsAtZoom(zoomLevel).getX() + longitude * info.getLongitudeDegreeWidthInPixels(zoomLevel);
        double e = Math.sin(latitude * (Math.PI / 180));
        if (e > 0.9999) {
            e = 0.9999;
        }
        if (e < -0.9999) {
            e = -0.9999;
        }
        double y = info.getMapCenterInPixelsAtZoom(zoomLevel).getY() + 0.5 * Math.log((1.0 + e) / (1.0 - e)) * -1.0 * info.getLongitudeRadianWidthInPixels(zoomLevel);
        return new Point2D.Double(x, y);
    }

    public static GeoPosition getPosition(Point2D pixelCoordinate, int zoom, TileProviderInfo info) {
        double e2;
        double wx = pixelCoordinate.getX();
        double wy = pixelCoordinate.getY();
        double flon = (wx - info.getMapCenterInPixelsAtZoom(zoom).getX()) / info.getLongitudeDegreeWidthInPixels(zoom);
        double e1 = (wy - info.getMapCenterInPixelsAtZoom(zoom).getY()) / (-1.0 * info.getLongitudeRadianWidthInPixels(zoom));
        double flat = e2 = (2.0 * Math.atan(Math.exp(e1)) - 1.5707963267948966) / (Math.PI / 180);
        GeoPosition wc = new GeoPosition(flat, flon);
        return wc;
    }
}

