/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.TilePoint;

public final class GoogleUtil {
    static final int TILE_SIZE = 256;
    private static final double[] PIXELS_PER_LON_DEGREE = new double[18];
    private static final double[] PIXELS_PER_LON_RADIAN = new double[18];
    private static final int[] NUM_TILES_WIDE = new int[18];
    private static final Point2D[] BITMAP_ORIGIN = new Point2D.Double[18];
    private static final double Wa = Math.PI / 180;

    private GoogleUtil() {
    }

    public static Dimension getMapSize(int zoom) {
        return new Dimension(NUM_TILES_WIDE[zoom], NUM_TILES_WIDE[zoom]);
    }

    public static double getBitmapOriginX(int zoomLevel) {
        return BITMAP_ORIGIN[zoomLevel].getX();
    }

    public static Point2D getBitmapCoordinate(GeoPosition c, int zoomLevel) {
        return GoogleUtil.getBitmapCoordinate(c.getLatitude(), c.getLongitude(), zoomLevel);
    }

    public static Point2D getBitmapCoordinate(double latitude, double longitude, int zoomLevel) {
        double x = BITMAP_ORIGIN[zoomLevel].getX() + longitude * PIXELS_PER_LON_DEGREE[zoomLevel];
        double e = Math.sin(latitude * (Math.PI / 180));
        if (e > 0.9999) {
            e = 0.9999;
        }
        if (e < -0.9999) {
            e = -0.9999;
        }
        double y = BITMAP_ORIGIN[zoomLevel].getY() + 0.5 * Math.log((1.0 + e) / (1.0 - e)) * -1.0 * PIXELS_PER_LON_RADIAN[zoomLevel];
        return new Point2D.Double(x, y);
    }

    public static TilePoint getTileCoordinate(double latitude, double longitude, int zoomLevel) {
        return GoogleUtil.getTileCoordinate(GoogleUtil.getBitmapCoordinate(latitude, longitude, zoomLevel));
    }

    public static TilePoint getTileCoordinate(Point2D pixelCoordinate) {
        int x = (int)Math.floor(pixelCoordinate.getX() / 256.0);
        int y = (int)Math.floor(pixelCoordinate.getY() / 256.0);
        return new TilePoint(x, y);
    }

    public static boolean isValidTile(TilePoint coord, int zoomLevel) {
        int x = coord.getX();
        int y = coord.getY();
        if (x < 0 || y < 0) {
            return false;
        }
        if (BITMAP_ORIGIN[zoomLevel].getX() * 2.0 <= (double)(x * 256)) {
            return false;
        }
        if (BITMAP_ORIGIN[zoomLevel].getY() * 2.0 <= (double)(y * 256)) {
            return false;
        }
        return zoomLevel >= 0 && zoomLevel <= 15;
    }

    public static double getPixelsPerLongitudeDegree(int zoomLevel) {
        return PIXELS_PER_LON_DEGREE[zoomLevel];
    }

    public static GeoPosition getPosition(Point2D pixelCoordinate, int zoom) {
        double e2;
        double wx = pixelCoordinate.getX();
        double wy = pixelCoordinate.getY();
        double flon = (wx - BITMAP_ORIGIN[zoom].getX()) / PIXELS_PER_LON_DEGREE[zoom];
        double e1 = (wy - BITMAP_ORIGIN[zoom].getY()) / (-1.0 * PIXELS_PER_LON_RADIAN[zoom]);
        double flat = e2 = (2.0 * Math.atan(Math.exp(e1)) - 1.5707963267948966) / (Math.PI / 180);
        GeoPosition wc = new GeoPosition(flat, flon);
        return wc;
    }

    static {
        int c = 256;
        double bc = Math.PI * 2;
        for (int d = 17; d >= 0; --d) {
            GoogleUtil.PIXELS_PER_LON_DEGREE[d] = (double)c / 360.0;
            GoogleUtil.PIXELS_PER_LON_RADIAN[d] = (double)c / (Math.PI * 2);
            int e = c / 2;
            GoogleUtil.BITMAP_ORIGIN[d] = new Point2D.Double(e, e);
            GoogleUtil.NUM_TILES_WIDE[d] = c / 256;
            c *= 2;
        }
    }
}

