/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import org.jdesktop.swingx.GoogleUtil;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.Tile;
import org.jdesktop.swingx.mapviewer.TileFactory;
import org.jdesktop.swingx.mapviewer.TilePoint;

public class GoogleTileFactory
extends TileFactory {
    private static final boolean doEagerLoading = true;
    private Map<String, Tile> tileMap = new HashMap<String, Tile>();

    public int getTileSize() {
        return 256;
    }

    public Dimension getMapSize(int zoom) {
        return GoogleUtil.getMapSize(zoom);
    }

    public Tile getTile(TilePoint tilePoint, int zoom) {
        return this.getTile(tilePoint, zoom, true);
    }

    private Tile getTile(TilePoint tilePoint, int zoom, boolean eagerLoad) {
        int tileX = tilePoint.getX();
        int numTilesWide = (int)this.getMapSize(zoom).getWidth();
        if (tileX < 0) {
            tileX = numTilesWide - Math.abs(tileX) % numTilesWide;
        }
        tilePoint = new TilePoint(tileX %= numTilesWide, tilePoint.getY());
        String url = this.getTileUrl(zoom, tilePoint);
        Tile.Priority pri = Tile.Priority.High;
        if (!eagerLoad) {
            pri = Tile.Priority.Low;
        }
        Tile tile = null;
        if (!this.tileMap.containsKey(url)) {
            tile = !GoogleUtil.isValidTile(tilePoint, zoom) ? new Tile(tilePoint, zoom) : new Tile(tilePoint, zoom, url, pri);
            this.tileMap.put(url, tile);
        } else {
            tile = this.tileMap.get(url);
            if (tile.getPriority() == Tile.Priority.Low && eagerLoad && !tile.isLoaded()) {
                tile.promote();
            }
        }
        if (eagerLoad) {
            for (int i = 0; i < 1; ++i) {
                for (int j = 0; j < 1; ++j) {
                    if (zoom <= 0) continue;
                    this.eagerlyLoad(tilePoint.getX() * 2, tilePoint.getY() * 2, zoom - 1);
                    this.eagerlyLoad(tilePoint.getX() * 2 + 1, tilePoint.getY() * 2, zoom - 1);
                    this.eagerlyLoad(tilePoint.getX() * 2, tilePoint.getY() * 2 + 1, zoom - 1);
                    this.eagerlyLoad(tilePoint.getX() * 2 + 1, tilePoint.getY() * 2 + 1, zoom - 1);
                }
            }
        }
        return tile;
    }

    private void eagerlyLoad(int x, int y, int zoom) {
        TilePoint t1 = new TilePoint(x, y);
        if (!this.isLoaded(t1, zoom)) {
            this.getTile(t1, zoom, false);
        }
    }

    private boolean isLoaded(TilePoint tilePoint, int zoom) {
        String url = this.getTileUrl(zoom, tilePoint);
        return this.tileMap.containsKey(url);
    }

    private String getTileUrl(int zoom, TilePoint tilePoint) {
        String url = "http://mt.google.com/mt?v=w2.29&x=" + tilePoint.getX() + "&y=" + tilePoint.getY() + "&zoom=" + zoom;
        return url;
    }

    public GeoPosition pixelToGeo(Point2D pixelCoordinate, int zoom) {
        return GoogleUtil.getPosition(pixelCoordinate, zoom);
    }

    public Point2D getBitmapCoordinate(GeoPosition c, int zoomLevel) {
        return GoogleUtil.getBitmapCoordinate(c, zoomLevel);
    }

    public TilePoint getTileCoordinate(double latitude, double longitude, int zoomLevel) {
        return GoogleUtil.getTileCoordinate(latitude, longitude, zoomLevel);
    }

    public TilePoint getTileCoordinate(Point2D pixelCoordinate) {
        return GoogleUtil.getTileCoordinate(pixelCoordinate);
    }
}

