/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.http.Header;
import org.jdesktop.http.Method;
import org.jdesktop.http.Parameter;
import org.jdesktop.xpath.XPathUtils;
import org.w3c.dom.Document;

public class Request
extends AbstractBean {
    private Set<Header> headers = new HashSet<Header>();
    private Set<Parameter> params = new HashSet<Parameter>();
    private boolean followRedirects = true;
    private Method method = Method.GET;
    private String url;
    private InputStream requestBody;
    private File[] multipart;
    private int chunkSizes = (int)Math.pow(2.0, 16.0);
    private boolean chunked = false;

    public Request() {
    }

    public Request(Request source) {
        if (source != null) {
            this.headers.addAll(source.headers);
            this.params.addAll(source.params);
            this.followRedirects = source.followRedirects;
            this.method = source.method;
            this.url = source.url;
        }
    }

    public Header getHeader(String name) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        for (Header h : this.headers) {
            if (!name.equalsIgnoreCase(h.getName())) continue;
            return h;
        }
        return null;
    }

    public void setHeader(Header header) {
        if (header == null) {
            throw new NullPointerException("header cannot be null");
        }
        this.headers.add(header);
    }

    public void removeHeader(Header header) {
        if (header != null) {
            this.headers.remove((Object)header);
        }
    }

    public void removeHeader(String header) {
        if (header != null) {
            for (Header h : this.headers) {
                if (!h.getName().equalsIgnoreCase(header)) continue;
                this.headers.remove((Object)h);
                break;
            }
        }
    }

    public Header[] getHeaders() {
        return this.headers.toArray(new Header[0]);
    }

    public void setHeaders(Header ... headers) {
        this.headers.clear();
        if (headers != null) {
            for (Header h : headers) {
                this.setHeader(h);
            }
        }
    }

    public Parameter getParameter(String name) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        for (Parameter p : this.params) {
            if (!name.equals(p.getName())) continue;
            return p;
        }
        return null;
    }

    public void setParameter(Parameter param) {
        if (param == null) {
            throw new NullPointerException("param cannot be null");
        }
        this.params.add(param);
    }

    public Parameter[] getParameters() {
        return this.params.toArray(new Parameter[0]);
    }

    public void setParameters(Parameter ... params) {
        this.params.clear();
        if (params != null) {
            for (Parameter p : params) {
                this.setParameter(p);
            }
        }
    }

    public void setFollowRedirects(boolean b) {
        boolean old = this.getFollowRedirects();
        this.followRedirects = b;
        this.firePropertyChange("followRedirects", old, this.getFollowRedirects());
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setMethod(Method method) {
        Method old = this.getMethod();
        this.method = method == null ? Method.GET : method;
        this.firePropertyChange("method", (Object)old, (Object)this.getMethod());
    }

    public Method getMethod() {
        return this.method;
    }

    public void setUrl(String url) throws IllegalArgumentException {
        String old = this.getUrl();
        this.url = url;
        this.firePropertyChange("url", old, this.getUrl());
    }

    public String getUrl() {
        return this.url;
    }

    public void setBody(String body) {
        this.setBody(body == null ? null : body.getBytes());
    }

    public void setBody(byte[] body) {
        if (body == null || body.length == 0) {
            this.requestBody = null;
        } else {
            this.setBody(new ByteArrayInputStream(body));
        }
    }

    public void setBody(Document body) {
        this.setBody(body == null ? null : XPathUtils.toXML(body));
    }

    public void setBody(InputStream body) {
        this.requestBody = body;
    }

    InputStream getBody() {
        return this.requestBody;
    }

    public void setMultipart(File ... files) {
        if (files != null) {
            for (File f : files) {
                if (f != null) continue;
                throw new NullPointerException("File argument cannot be null");
            }
            this.multipart = new File[files.length];
            System.arraycopy(files, 0, this.multipart, 0, files.length);
        } else {
            this.multipart = null;
        }
    }

    File[] getMultipart() {
        return this.multipart;
    }

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    public void setChunkSizes(int size) {
        this.chunkSizes = size;
    }

    boolean isChunked() {
        return this.chunked;
    }

    int getChunkSizes() {
        return this.chunkSizes;
    }
}

