/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Set;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.mapviewer.DefaultWaypointRenderer;
import org.jdesktop.swingx.mapviewer.MapOverlay;
import org.jdesktop.swingx.mapviewer.Waypoint;
import org.jdesktop.swingx.mapviewer.WaypointRenderer;
import org.jdesktop.swingx.painter.AbstractPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WaypointMapOverlay<T extends JXMapViewer>
extends AbstractPainter<T>
implements MapOverlay<T> {
    private WaypointRenderer renderer = new DefaultWaypointRenderer();
    private Set waypoints;

    public WaypointMapOverlay() {
        this.setUseCache(false);
        this.setAntialiasing(RenderingHints.VALUE_ANTIALIAS_ON);
        this.waypoints = new HashSet();
    }

    public void setRenderer(WaypointRenderer r) {
        this.renderer = r;
    }

    public Set<Waypoint> getWaypoints() {
        return this.waypoints;
    }

    protected void paintBackground(Graphics2D g, T map) {
        if (this.renderer == null) {
            return;
        }
        Rectangle viewportBounds = ((JXMapViewer)map).getViewportBounds();
        Waypoint waypointWithPopup = null;
        for (Waypoint w : this.getWaypoints()) {
            Point2D point = ((JXMapViewer)map).getTileFactory().getBitmapCoordinate(w.getPosition(), ((JXMapViewer)map).getZoom());
            System.out.println("testing: " + viewportBounds + " " + point);
            if (!viewportBounds.contains(point) || !this.renderer.paintWaypoint(g, (JXMapViewer)map, w)) continue;
            waypointWithPopup = w;
        }
        if (waypointWithPopup != null) {
            this.paintWaypointSummary(g, (JXMapViewer)map, waypointWithPopup);
        }
    }

    protected abstract void paintWaypointSummary(Graphics2D var1, JXMapViewer var2, Waypoint var3);

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

