/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.GeoUtil;
import org.jdesktop.swingx.mapviewer.Tile;
import org.jdesktop.swingx.mapviewer.TileFactory;
import org.jdesktop.swingx.mapviewer.TilePoint;
import org.jdesktop.swingx.mapviewer.TileProviderInfo;

public class DefaultTileFactory
extends TileFactory {
    protected static final boolean doEagerLoading = true;
    private TileProviderInfo info;
    protected Map<String, Tile> tileMap = new HashMap<String, Tile>();

    public DefaultTileFactory(TileProviderInfo info) {
        this.info = info;
    }

    public int getTileSize() {
        return this.getInfo().getTileSize();
    }

    public Dimension getMapSize(int zoom) {
        return GeoUtil.getMapSize(zoom, this.getInfo());
    }

    public Point2D getBitmapCoordinate(GeoPosition c, int zoomLevel) {
        return GeoUtil.getBitmapCoordinate(c, zoomLevel, this.getInfo());
    }

    public TilePoint getTileCoordinate(Point2D pixelCoordinate) {
        return GeoUtil.getTileCoordinate(pixelCoordinate, this.getInfo());
    }

    public TilePoint getTileCoordinate(double latitude, double longitude, int zoomLevel) {
        return GeoUtil.getTileCoordinate(latitude, longitude, zoomLevel, this.getInfo());
    }

    public GeoPosition pixelToGeo(Point2D pixelCoordinate, int zoom) {
        return GeoUtil.getPosition(pixelCoordinate, zoom, this.getInfo());
    }

    protected void eagerlyLoad(int x, int y, int zoom) {
        TilePoint t1 = new TilePoint(x, y);
        if (!this.isLoaded(t1, zoom)) {
            this.getTile(t1, zoom, false);
        }
    }

    public Tile getTile(TilePoint tilePoint, int zoom) {
        return this.getTile(tilePoint, zoom, true);
    }

    protected Tile getTile(TilePoint tilePoint, int zoom, boolean eagerLoad) {
        int tileX = tilePoint.getX();
        int numTilesWide = (int)this.getMapSize(zoom).getWidth();
        if (tileX < 0) {
            tileX = numTilesWide - Math.abs(tileX) % numTilesWide;
        }
        tilePoint = new TilePoint(tileX %= numTilesWide, tilePoint.getY());
        String url = this.getInfo().getTileUrl(zoom, tilePoint);
        Tile.Priority pri = Tile.Priority.High;
        if (!eagerLoad) {
            pri = Tile.Priority.Low;
        }
        Tile tile = null;
        if (!this.tileMap.containsKey(url)) {
            tile = !GeoUtil.isValidTile(tilePoint, zoom, this.getInfo()) ? new Tile(tilePoint, zoom) : new Tile(tilePoint, zoom, url, pri);
            this.tileMap.put(url, tile);
        } else {
            tile = this.tileMap.get(url);
            if (tile.getPriority() == Tile.Priority.Low && eagerLoad && !tile.isLoaded()) {
                tile.promote();
            }
        }
        return tile;
    }

    protected boolean isLoaded(TilePoint tilePoint, int zoom) {
        String url = this.getInfo().getTileUrl(zoom, tilePoint);
        return this.tileMap.containsKey(url);
    }

    public TileProviderInfo getInfo() {
        return this.info;
    }
}

