/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.DesignMode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.MapOverlay;
import org.jdesktop.swingx.mapviewer.Tile;
import org.jdesktop.swingx.mapviewer.TileFactory;
import org.jdesktop.swingx.mapviewer.TilePoint;
import org.jdesktop.swingx.mapviewer.TileProviderInfo;
import org.jdesktop.swingx.mapviewer.empty.EmptyTileFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXMapViewer
extends JPanel
implements DesignMode {
    private int zoom = 1;
    private Point2D center = new Point2D.Double(0.0, 0.0);
    private boolean drawTileBorders = false;
    private TileFactory factory;
    private GeoPosition addressLocation;
    private boolean panEnabled = true;
    private boolean zoomEnabled = true;
    private boolean recenterOnClickEnabled = true;
    private MapOverlay<JXMapViewer> mapOverlay;
    private boolean designTime;
    private float zoomScale = 1.0f;
    private Image loadingImage;
    private TileLoadListener tileLoadListener = new TileLoadListener();

    public JXMapViewer() {
        this.factory = new EmptyTileFactory();
        PanMouseInputListener mia = new PanMouseInputListener();
        this.setRecenterOnClickEnabled(false);
        this.addMouseListener(mia);
        this.addMouseMotionListener(mia);
        this.addMouseWheelListener(new ZoomMouseWheelListener());
        this.addKeyListener(new PanKeyListener());
        BufferedImage img = new BufferedImage(16, 16, 2);
        Graphics2D g2 = img.createGraphics();
        g2.setColor(Color.black);
        g2.fillRect(0, 0, 16, 16);
        g2.dispose();
        this.setLoadingImage(img);
    }

    @Override
    public void setDesignTime(boolean b) {
        this.designTime = b;
    }

    @Override
    public boolean isDesignTime() {
        return this.designTime;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.isOpaque() || this.isDesignTime()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (!this.isDesignTime()) {
            int zoom = this.getZoom();
            Rectangle viewportBounds = this.getViewportBounds();
            this.drawMapTiles(g, zoom, viewportBounds);
            this.drawOverlays(zoom, g, viewportBounds);
        }
    }

    private void drawOverlays(int zoom, Graphics g, Rectangle viewportBounds) {
        if (this.mapOverlay != null) {
            this.mapOverlay.paint((Graphics2D)g, this);
        }
    }

    public void drawMapTiles(Graphics g, int zoom, Rectangle viewportBounds) {
        int size = this.getFactory().getTileSize();
        Dimension mapSize = this.getFactory().getMapSize(zoom);
        int numWide = viewportBounds.width / size + 1;
        int numHigh = viewportBounds.height / size + 1;
        TilePoint topLeftTile = this.getFactory().getTileCoordinate(new Point2D.Double(viewportBounds.x, viewportBounds.y));
        for (int x = 0; x <= numWide; ++x) {
            for (int y = 0; y <= numHigh; ++y) {
                TilePoint point = new TilePoint(x + topLeftTile.getX(), y + topLeftTile.getY());
                if (!g.getClipBounds().intersects(new Rectangle(point.getX() * size - viewportBounds.x, point.getY() * size - viewportBounds.y, size, size))) continue;
                Tile tile = this.getFactory().getTile(point, zoom);
                tile.addUniquePropertyChangeListener("loaded", this.tileLoadListener);
                int ox = point.getX() * this.getFactory().getTileSize() - viewportBounds.x;
                int oy = point.getY() * this.getFactory().getTileSize() - viewportBounds.y;
                if (point.getY() < 0 || (double)point.getY() >= mapSize.getHeight()) {
                    if (this.isOpaque()) {
                        g.setColor(this.getBackground());
                        g.fillRect(ox, oy, size, size);
                    }
                } else if (tile.isLoaded()) {
                    g.drawImage(tile.getImage(), ox, oy, null);
                } else {
                    int imageX = (this.getFactory().getTileSize() - this.getLoadingImage().getWidth(null)) / 2;
                    int imageY = (this.getFactory().getTileSize() - this.getLoadingImage().getHeight(null)) / 2;
                    g.drawImage(this.getLoadingImage(), ox + imageX, oy + imageY, null);
                }
                if (!this.isDrawTileBorders()) continue;
                g.setColor(Color.black);
                g.drawRect(ox, oy, size, size);
            }
        }
    }

    public void setMapOverlay(MapOverlay<? extends JXMapViewer> overlay) {
        MapOverlay<? extends JXMapViewer> old = this.getMapOverlay();
        this.mapOverlay = overlay;
        this.firePropertyChange("mapOverlay", old, this.getMapOverlay());
        this.repaint();
    }

    public MapOverlay<? extends JXMapViewer> getMapOverlay() {
        return this.mapOverlay;
    }

    public Rectangle getViewportBounds() {
        Insets insets = this.getInsets();
        int viewportWidth = this.getWidth() - insets.left - insets.right;
        int viewportHeight = this.getHeight() - insets.top - insets.bottom;
        double viewportX = this.center.getX() - (double)(viewportWidth / 2);
        double viewportY = this.center.getY() - (double)(viewportHeight / 2);
        return new Rectangle((int)viewportX, (int)viewportY, viewportWidth, viewportHeight);
    }

    public static GeoPosition getPositionForAddress(String street, String city, String state) throws IOException {
        try {
            URL load = new URL("http://api.local.yahoo.com/MapsService/V1/geocode?appid=joshy688&street=" + street.replace(' ', '+') + "&city=" + city.replace(' ', '+') + "&state=" + state.replace(' ', '+'));
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(load.openConnection().getInputStream());
            XPath xpath = XPathFactory.newInstance().newXPath();
            Double lat = (Double)xpath.evaluate("//Result/Latitude/text()", doc, XPathConstants.NUMBER);
            Double lon = (Double)xpath.evaluate("//Result/Longitude/text()", doc, XPathConstants.NUMBER);
            return new GeoPosition(lat, lon);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Failed to retrieve location information from the internet: " + e.toString());
        }
    }

    public void setRecenterOnClickEnabled(boolean b) {
        boolean old = this.isRecenterOnClickEnabled();
        this.recenterOnClickEnabled = b;
        this.firePropertyChange("recenterOnClickEnabled", old, this.isRecenterOnClickEnabled());
    }

    public boolean isRecenterOnClickEnabled() {
        return this.recenterOnClickEnabled;
    }

    public void setZoom(int zoom) {
        TileProviderInfo info = this.getFactory().getInfo();
        if (info == null || info != null && zoom >= info.getMinimumZoomLevel() && zoom <= info.getMaximumZoomLevel() && zoom != this.zoom) {
            int oldzoom = this.zoom;
            Point2D oldCenter = this.center;
            Dimension oldMapSize = this.getFactory().getMapSize(oldzoom);
            this.zoom = zoom;
            this.firePropertyChange("zoom", oldzoom, zoom);
            Dimension mapSize = this.getFactory().getMapSize(zoom);
            this.center = new Point2D.Double(oldCenter.getX() * (mapSize.getWidth() / oldMapSize.getWidth()), oldCenter.getY() * (mapSize.getHeight() / oldMapSize.getHeight()));
            this.repaint();
        }
    }

    public int getZoom() {
        return this.zoom;
    }

    public GeoPosition getAddressLocation() {
        return this.addressLocation;
    }

    public void setAddressLocation(GeoPosition addressLocation) {
        GeoPosition old = this.getAddressLocation();
        this.addressLocation = addressLocation;
        this.center = this.getTileFactory().getBitmapCoordinate(addressLocation, this.getZoom());
        this.firePropertyChange("addressLocation", old, this.getAddressLocation());
        this.repaint();
    }

    public boolean isDrawTileBorders() {
        return this.drawTileBorders;
    }

    public void setDrawTileBorders(boolean drawTileBorders) {
        boolean old = this.isDrawTileBorders();
        this.drawTileBorders = drawTileBorders;
        this.firePropertyChange("drawTileBorders", old, this.isDrawTileBorders());
        this.repaint();
    }

    public boolean isPanEnabled() {
        return this.panEnabled;
    }

    public void setPanEnabled(boolean panEnabled) {
        boolean old = this.isPanEnabled();
        this.panEnabled = panEnabled;
        this.firePropertyChange("panEnabled", old, this.isPanEnabled());
    }

    public boolean isZoomEnabled() {
        return this.zoomEnabled;
    }

    public void setZoomEnabled(boolean zoomEnabled) {
        boolean old = this.isZoomEnabled();
        this.zoomEnabled = zoomEnabled;
        this.firePropertyChange("zoomEnabled", old, this.isZoomEnabled());
    }

    public TileFactory getTileFactory() {
        return this.getFactory();
    }

    public void setCenterPosition(GeoPosition geoPosition) {
        this.center = this.getTileFactory().getBitmapCoordinate(geoPosition, this.zoom);
        this.repaint();
    }

    public GeoPosition getCenterPosition() {
        return this.getTileFactory().pixelToGeo(this.center, this.zoom);
    }

    public float getZoomScale() {
        return this.zoomScale;
    }

    public void setZoomScale(float zoomScale) {
        this.zoomScale = zoomScale;
    }

    public TileFactory getFactory() {
        return this.factory;
    }

    public void setFactory(TileFactory factory) {
        this.factory = factory;
    }

    public Image getLoadingImage() {
        return this.loadingImage;
    }

    public void setLoadingImage(Image loadingImage) {
        this.loadingImage = loadingImage;
    }

    private class ZoomMouseWheelListener
    implements MouseWheelListener {
        private ZoomMouseWheelListener() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (JXMapViewer.this.isZoomEnabled()) {
                JXMapViewer.this.setZoom(JXMapViewer.this.getZoom() + e.getWheelRotation());
            }
        }
    }

    private class PanMouseInputListener
    implements MouseInputListener {
        Point prev;

        private PanMouseInputListener() {
        }

        public void mousePressed(MouseEvent evt) {
            if (JXMapViewer.this.isRecenterOnClickEnabled() && (SwingUtilities.isMiddleMouseButton(evt) || SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2)) {
                this.recenterMap(evt);
            } else {
                this.prev = evt.getPoint();
            }
            if (JXMapViewer.this.mapOverlay != null) {
                JXMapViewer.this.mapOverlay.mousePressed(evt);
            }
        }

        private void recenterMap(MouseEvent evt) {
            Rectangle bounds = JXMapViewer.this.getViewportBounds();
            double x = bounds.getX() + (double)evt.getX();
            double y = bounds.getY() + (double)evt.getY();
            JXMapViewer.this.center = new Point2D.Double(x, y);
            JXMapViewer.this.repaint();
        }

        public void mouseDragged(MouseEvent evt) {
            if (JXMapViewer.this.isPanEnabled()) {
                int maxHeight;
                Point current = evt.getPoint();
                double x = JXMapViewer.this.center.getX() - (double)(current.x - this.prev.x);
                double y = JXMapViewer.this.center.getY() - (double)(current.y - this.prev.y);
                if (y < 0.0) {
                    y = 0.0;
                }
                if (y > (double)(maxHeight = (int)(JXMapViewer.this.getFactory().getMapSize(JXMapViewer.this.getZoom()).getHeight() * (double)JXMapViewer.this.getFactory().getTileSize()))) {
                    y = maxHeight;
                }
                this.prev = current;
                JXMapViewer.this.center = new Point2D.Double(x, y);
                JXMapViewer.this.repaint();
                JXMapViewer.this.setCursor(Cursor.getPredefinedCursor(13));
            }
            if (JXMapViewer.this.mapOverlay != null) {
                JXMapViewer.this.mapOverlay.mouseDragged(evt);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            this.prev = null;
            JXMapViewer.this.setCursor(Cursor.getPredefinedCursor(0));
            if (JXMapViewer.this.mapOverlay != null) {
                JXMapViewer.this.mapOverlay.mouseReleased(evt);
            }
        }

        public void mouseMoved(MouseEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JXMapViewer.this.requestFocusInWindow();
                }
            });
            if (JXMapViewer.this.mapOverlay != null) {
                JXMapViewer.this.mapOverlay.mouseMoved(e);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (JXMapViewer.this.mapOverlay != null) {
                JXMapViewer.this.mapOverlay.mouseExited(e);
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (JXMapViewer.this.mapOverlay != null) {
                JXMapViewer.this.mapOverlay.mouseEntered(e);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (JXMapViewer.this.mapOverlay != null) {
                JXMapViewer.this.mapOverlay.mouseClicked(e);
            }
        }
    }

    private class PanKeyListener
    extends KeyAdapter {
        private static final int OFFSET = 10;

        private PanKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            int delta_x = 0;
            int delta_y = 0;
            switch (e.getKeyCode()) {
                case 37: {
                    delta_x = -10;
                    break;
                }
                case 39: {
                    delta_x = 10;
                    break;
                }
                case 38: {
                    delta_y = -10;
                    break;
                }
                case 40: {
                    delta_y = 10;
                }
            }
            if (delta_x != 0 || delta_y != 0) {
                Rectangle bounds = JXMapViewer.this.getViewportBounds();
                double x = bounds.getCenterX() + (double)delta_x;
                double y = bounds.getCenterY() + (double)delta_y;
                JXMapViewer.this.center = new Point2D.Double(x, y);
                JXMapViewer.this.repaint();
            }
        }
    }

    private final class TileLoadListener
    implements PropertyChangeListener {
        private TileLoadListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            TilePoint tilePoint;
            Point point;
            Rectangle tileRect;
            Rectangle viewportBounds;
            Tile t;
            if ("loaded".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue()) && (t = (Tile)((Object)evt.getSource())).getZoom() == JXMapViewer.this.getZoom() && (viewportBounds = JXMapViewer.this.getViewportBounds()).intersects(tileRect = new Rectangle(point = new Point((tilePoint = t.getLocation()).getX() * JXMapViewer.this.getFactory().getTileSize(), tilePoint.getY() * JXMapViewer.this.getFactory().getTileSize()), new Dimension(JXMapViewer.this.getFactory().getTileSize(), JXMapViewer.this.getFactory().getTileSize())))) {
                JXMapViewer.this.repaint(new Rectangle(tileRect.x - viewportBounds.x, tileRect.y - viewportBounds.y, tileRect.width, tileRect.height));
            }
        }
    }
}

