/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http.async;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jdesktop.html.form.AbstractForm;
import org.jdesktop.html.form.DefaultInput;
import org.jdesktop.html.form.Forms;
import org.jdesktop.html.form.Input;
import org.jdesktop.http.Method;
import org.jdesktop.http.Parameter;
import org.jdesktop.http.async.AsyncHttpRequest;

public class AsyncTest {
    private AsyncTest() {
    }

    public static void main(String[] args) {
        AsyncTest.testSimpleForm2();
    }

    public static void simpleTest() {
        final AsyncHttpRequest req = new AsyncHttpRequest();
        req.open(Method.GET, "http://www.google.com");
        req.setOnReadyStateChange(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (req.getReadyState() == AsyncHttpRequest.ReadyState.LOADED) {
                    System.out.println("Loaded!");
                }
            }
        });
        req.send();
    }

    public static void testSimpleParameter() {
        final AsyncHttpRequest req = new AsyncHttpRequest();
        req.open(Method.GET, "http://www.jroller.com/page/jmn");
        req.setParameter(new Parameter("entry", "swingx_wants_you"));
        req.setOnReadyStateChange(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (req.getReadyState() == AsyncHttpRequest.ReadyState.LOADED) {
                    System.out.println(req.getResponseText());
                }
            }
        });
        req.send();
    }

    public static void testSimpleHeader() {
        final AsyncHttpRequest req = new AsyncHttpRequest();
        req.open(Method.GET, "http://www.google.com");
        req.setRequestHeader("Content-Type", "text");
        req.setOnReadyStateChange(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (req.getReadyState() == AsyncHttpRequest.ReadyState.LOADED) {
                    System.out.println(req.getResponseHeader("Content-Type"));
                }
            }
        });
        req.send();
    }

    public static void testSimpleForm() {
        final AsyncHttpRequest req = new AsyncHttpRequest();
        req.open(Method.GET, "http://www.google.com/search");
        req.setOnReadyStateChange(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (req.getReadyState() == AsyncHttpRequest.ReadyState.LOADED) {
                    System.out.println(req.getResponseText());
                }
            }
        });
        req.setParameter("h1", "en");
        req.setParameter("q", "SwingLabs");
        req.send();
    }

    public static void testSimpleForm2() {
        DefaultInput lang = new DefaultInput("h1", "en");
        DefaultInput query = new DefaultInput("q", "SwingLabs");
        AbstractForm form = new AbstractForm("http://www.google.com", new Input[]{lang, query}){

            public String getAction() {
                return "/search";
            }

            public Method getMethod() {
                return Method.GET;
            }
        };
        final AsyncHttpRequest req = new AsyncHttpRequest();
        req.open(form.getMethod(), form.getBaseUrl() + form.getAction());
        req.setParameters(Forms.getParameters(form));
        req.setOnReadyStateChange(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (req.getReadyState() == AsyncHttpRequest.ReadyState.LOADED) {
                    System.out.println(req.getResponseText());
                }
            }
        });
        req.send();
    }
}

