/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.FilePartSource;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.http.DefaultSecurityHandler;
import org.jdesktop.http.Header;
import org.jdesktop.http.Method;
import org.jdesktop.http.Parameter;
import org.jdesktop.http.Request;
import org.jdesktop.http.Response;
import org.jdesktop.http.SSLProtocolSocketFactory;
import org.jdesktop.http.SecurityHandler;
import org.jdesktop.http.StatusCode;

public class Session
extends AbstractBean {
    private HttpClient client = new HttpClient();
    private SecurityLevel sslSecurity;
    private SecurityHandler handler;
    private long bytesSent = -1L;
    private long requestLength = -1L;
    private TrackablePartSource[] parts = null;

    public Session() {
        this.setSslSecurityLevel(SecurityLevel.Medium);
        this.setMediumSecurityHandler(new DefaultSecurityHandler());
    }

    public void setSslSecurityLevel(SecurityLevel level) {
        SecurityLevel old = this.getSslSecurityLevel();
        this.sslSecurity = level;
        Protocol https = null;
        https = new Protocol("https", (ProtocolSocketFactory)new SSLProtocolSocketFactory(this.getMediumSecurityHandler(), this.getSslSecurityLevel()), 443);
        Protocol.registerProtocol((String)"https", (Protocol)https);
        this.firePropertyChange("sslSecurityLevel", (Object)old, (Object)this.getSslSecurityLevel());
    }

    public SecurityLevel getSslSecurityLevel() {
        return this.sslSecurity;
    }

    void setMediumSecurityHandler(SecurityHandler h) {
        SecurityHandler old = this.getMediumSecurityHandler();
        this.handler = h;
        this.firePropertyChange("mediumSecurityHandler", old, this.getMediumSecurityHandler());
    }

    SecurityHandler getMediumSecurityHandler() {
        return this.handler;
    }

    public Response get(String url) throws Exception {
        return this.execute(Method.GET, url);
    }

    public Response get(String url, Parameter ... params) throws Exception {
        return this.execute(Method.GET, url, params);
    }

    public Response post(String url) throws Exception {
        return this.execute(Method.POST, url);
    }

    public Response post(String url, Parameter ... params) throws Exception {
        return this.execute(Method.POST, url, params);
    }

    public Response execute(Method method, String url) throws Exception {
        return this.execute(method, url, new Parameter[0]);
    }

    public Response execute(Method method, String url, Parameter ... params) throws Exception {
        if (method == null) {
            throw new NullPointerException("method cannot be null");
        }
        if (url == null) {
            throw new NullPointerException("url cannot be null");
        }
        Request req = new Request();
        req.setParameters(params);
        req.setMethod(method);
        req.setUrl(url);
        return this.execute(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response execute(Request req) throws Exception {
        try {
            Method method = req.getMethod();
            URL url = new URL(req.getUrl());
            GetMethod http = null;
            if (method == Method.GET) {
                http = new GetMethod(url.toURI().toString());
            } else if (method == Method.POST) {
                http = new PostMethod(url.toURI().toString());
            } else if (method == Method.PUT) {
                http = new PutMethod(url.toURI().toString());
            } else if (method == Method.DELETE) {
                http = new DeleteMethod(url.toURI().toString());
            } else if (method == Method.HEAD) {
                http = new HeadMethod(url.toURI().toString());
            } else {
                throw new IllegalArgumentException("Not implemented");
            }
            http.getParams().setCookiePolicy("compatibility");
            if (method != Method.POST && method != Method.PUT) {
                http.setFollowRedirects(req.getFollowRedirects());
            }
            for (Header h : req.getHeaders()) {
                http.setRequestHeader(h.getName(), h.getValue());
            }
            if (req.getHeader("Accept-Encoding") == null) {
                http.setRequestHeader("Accept-Encoding", "gzip");
            }
            Parameter[] params = req.getParameters();
            NameValuePair[] p = new NameValuePair[params.length];
            for (int i = 0; i < params.length; ++i) {
                p[i] = new NameValuePair(params[i].getName(), params[i].getValue());
            }
            if (method == Method.POST) {
                ((PostMethod)http).setRequestBody(p);
            }
            File[] f = req.getMultipart();
            if (method == Method.POST && f != null && f.length > 0) {
                Part[] parts = new Part[f.length];
                this.parts = new TrackablePartSource[f.length];
                for (int i = 0; i < parts.length; ++i) {
                    this.parts[i] = new TrackablePartSource((PartSource)new FilePartSource(f[i]));
                    parts[i] = new FilePart(f[i].getName(), (PartSource)this.parts[i]);
                }
                ((PostMethod)http).setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, http.getParams()));
            }
            if (req.isChunked() && http instanceof EntityEnclosingMethod) {
                ((EntityEnclosingMethod)http).setContentChunked(true);
                ((EntityEnclosingMethod)http).setRequestContentLength(req.getChunkSizes());
            }
            try {
                int redirectCount = 100;
                while (redirectCount-- > 0) {
                    this.client.executeMethod((HttpMethod)http);
                    String redirectLocation = null;
                    org.apache.commons.httpclient.Header locationHeader = http.getResponseHeader("location");
                    if (req.getFollowRedirects() && locationHeader != null && http.getStatusCode() > 300 && http.getStatusCode() < 400) {
                        String referer = http.getURI().toString();
                        redirectLocation = locationHeader.getValue();
                        http.releaseConnection();
                        http = new GetMethod(redirectLocation);
                        http.addRequestHeader("Referer", referer);
                        continue;
                    }
                    redirectCount = 0;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HashSet<Header> headers = new HashSet<Header>();
            boolean gzipEncoded = false;
            for (org.apache.commons.httpclient.Header h : http.getResponseHeaders()) {
                HeaderElement[] els = h.getElements();
                Header.Element[] elements = new Header.Element[els.length];
                for (int i = 0; i < els.length; ++i) {
                    HeaderElement el = els[i];
                    NameValuePair[] ps = el.getParameters();
                    Parameter[] results = new Parameter[ps == null ? 0 : ps.length];
                    for (int j = 0; j < results.length; ++j) {
                        results[j] = new Parameter();
                        results[j].setName(ps[j].getName());
                        results[j].setValue(ps[j].getValue());
                    }
                    elements[i] = new Header.Element(results);
                }
                headers.add(new Header(h.getName(), h.getValue(), elements));
                if (!h.getName().equalsIgnoreCase("Content-Encoding") || !h.getValue().contains("gzip")) continue;
                gzipEncoded = true;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(8096);
            byte[] buffer = new byte[8096];
            int length = -1;
            InputStream in = http.getResponseBodyAsStream();
            if (gzipEncoded) {
                in = new GZIPInputStream(in);
            }
            while ((length = in.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
            in.close();
            Response response = new Response(StatusCode.valueOf(http.getStatusCode()), http.getStatusText(), out.toByteArray(), headers, req.getUrl());
            out.close();
            http.releaseConnection();
            Response response2 = response;
            return response2;
        }
        finally {
            this.bytesSent = -1L;
            this.requestLength = -1L;
            this.parts = null;
        }
    }

    public long getBytesSent() {
        if (this.parts != null) {
            long total = 0L;
            for (TrackablePartSource s : this.parts) {
                total += s.getBytesSent();
            }
            return total;
        }
        return this.bytesSent;
    }

    public long getRequestLength() {
        if (this.parts != null) {
            long total = 0L;
            for (TrackablePartSource s : this.parts) {
                total += s.getLength();
            }
            return total;
        }
        return this.requestLength;
    }

    private static final class TrackablePartSource
    implements PartSource {
        private PartSource delegate;
        private long bytesSent;

        public TrackablePartSource(PartSource ps) {
            if (ps == null) {
                throw new NullPointerException("PartSource delegate was null");
            }
            this.delegate = ps;
        }

        public long getBytesSent() {
            return this.bytesSent;
        }

        public InputStream createInputStream() throws IOException {
            final InputStream i = this.delegate.createInputStream();
            return new InputStream(){

                public int read() throws IOException {
                    int data = i.read();
                    if (data != -1) {
                        TrackablePartSource.this.bytesSent++;
                    }
                    return data;
                }
            };
        }

        public String getFileName() {
            return this.delegate.getFileName();
        }

        public long getLength() {
            return this.delegate.getLength();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SecurityLevel {
        Low,
        Medium,
        High;

    }
}

