/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dom;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.jdesktop.dom.SimpleDocumentBuilder;
import org.jdesktop.dom.SimpleNodeList;
import org.jdesktop.xpath.XPathUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class SimpleDocument
implements Document {
    private Document dom;
    private XPath xpath;
    private Map<String, SoftReference<XPathExpression>> cachedExpressions = new HashMap<String, SoftReference<XPathExpression>>();

    public SimpleDocument() {
        this(new SimpleDocumentBuilder().newPlainDocument());
    }

    public SimpleDocument(Document dom) {
        if (dom == null) {
            throw new NullPointerException("DOM Cannot be null");
        }
        this.dom = dom;
    }

    public String toXML() {
        return XPathUtils.toXML(this.dom);
    }

    public String toXML(Node n) {
        SimpleDocument temp = new SimpleDocument();
        Node nn = n.cloneNode(true);
        temp.adoptNode(nn);
        temp.appendChild(nn);
        return temp.toXML();
    }

    public SimpleNodeList getChildElements(Node node) {
        Node[] nodes = new Node[this.getChildElementCount(node)];
        int index = 0;
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1) continue;
            nodes[index++] = n;
        }
        return new SimpleNodeList(nodes);
    }

    public int getChildElementCount(Node node) {
        int count = 0;
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1) continue;
            ++count;
        }
        return count;
    }

    private XPathExpression compile(String expression) throws XPathExpressionException {
        XPathExpression e;
        SoftReference<XPathExpression> ref = this.cachedExpressions.get(expression);
        XPathExpression xPathExpression = e = ref == null ? null : ref.get();
        if (e == null) {
            this.cachedExpressions.remove(expression);
            e = XPathUtils.compile(expression);
            this.cachedExpressions.put(expression, new SoftReference<XPathExpression>(e));
        }
        return e;
    }

    public SimpleNodeList getElements(String expression) {
        try {
            return XPathUtils.getElements(this.compile(expression), (Node)this.dom);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public SimpleNodeList getElements(String expression, Node node) {
        try {
            return XPathUtils.getElements(this.compile(expression), node);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public Node getElement(String expression) {
        try {
            return XPathUtils.getElement(this.compile(expression), (Node)this.dom);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public Node getElement(String expression, Node node) {
        try {
            return XPathUtils.getElement(this.compile(expression), node);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String getString(String expression) {
        try {
            return XPathUtils.getString(this.compile(expression), (Node)this.dom);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String getString(String expression, Node node) {
        try {
            return XPathUtils.getString(this.compile(expression), node);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public DocumentType getDoctype() {
        return this.dom.getDoctype();
    }

    public DOMImplementation getImplementation() {
        return this.dom.getImplementation();
    }

    public Element getDocumentElement() {
        return this.dom.getDocumentElement();
    }

    public Element createElement(String tagName) throws DOMException {
        return this.dom.createElement(tagName);
    }

    public DocumentFragment createDocumentFragment() {
        return this.dom.createDocumentFragment();
    }

    public Text createTextNode(String data) {
        return this.dom.createTextNode(data);
    }

    public Comment createComment(String data) {
        return this.dom.createComment(data);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return this.dom.createCDATASection(data);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return this.dom.createProcessingInstruction(target, data);
    }

    public Attr createAttribute(String name) throws DOMException {
        return this.dom.createAttribute(name);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        return this.dom.createEntityReference(name);
    }

    public SimpleNodeList getElementsByTagName(String tagname) {
        return new SimpleNodeList(this.dom.getElementsByTagName(tagname));
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return this.dom.importNode(importedNode, deep);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.dom.createElementNS(namespaceURI, qualifiedName);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.dom.createAttributeNS(namespaceURI, qualifiedName);
    }

    public SimpleNodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return new SimpleNodeList(this.dom.getElementsByTagNameNS(namespaceURI, localName));
    }

    public Element getElementById(String elementId) {
        return this.dom.getElementById(elementId);
    }

    public String getInputEncoding() {
        return this.dom.getInputEncoding();
    }

    public String getXmlEncoding() {
        return this.dom.getXmlEncoding();
    }

    public boolean getXmlStandalone() {
        return this.dom.getXmlStandalone();
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        this.dom.setXmlStandalone(xmlStandalone);
    }

    public String getXmlVersion() {
        return this.dom.getXmlVersion();
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
        this.dom.setXmlVersion(xmlVersion);
    }

    public boolean getStrictErrorChecking() {
        return this.dom.getStrictErrorChecking();
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.dom.setStrictErrorChecking(strictErrorChecking);
    }

    public String getDocumentURI() {
        return this.dom.getDocumentURI();
    }

    public void setDocumentURI(String documentURI) {
        this.dom.setDocumentURI(documentURI);
    }

    public Node adoptNode(Node source) throws DOMException {
        return this.dom.adoptNode(source);
    }

    public DOMConfiguration getDomConfig() {
        return this.dom.getDomConfig();
    }

    public void normalizeDocument() {
        this.dom.normalizeDocument();
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return this.dom.renameNode(n, namespaceURI, qualifiedName);
    }

    public String getNodeName() {
        return this.dom.getNodeName();
    }

    public String getNodeValue() throws DOMException {
        return this.dom.getNodeValue();
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.dom.setNodeValue(nodeValue);
    }

    public short getNodeType() {
        return this.dom.getNodeType();
    }

    public Node getParentNode() {
        return this.dom.getParentNode();
    }

    public SimpleNodeList getChildNodes() {
        return new SimpleNodeList(this.dom.getChildNodes());
    }

    public Node getFirstChild() {
        return this.dom.getFirstChild();
    }

    public Node getLastChild() {
        return this.dom.getLastChild();
    }

    public Node getPreviousSibling() {
        return this.dom.getPreviousSibling();
    }

    public Node getNextSibling() {
        return this.dom.getNextSibling();
    }

    public NamedNodeMap getAttributes() {
        return this.dom.getAttributes();
    }

    public Document getOwnerDocument() {
        return this.dom.getOwnerDocument();
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.dom.insertBefore(newChild, refChild);
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return this.dom.replaceChild(newChild, oldChild);
    }

    public Node removeChild(Node oldChild) throws DOMException {
        return this.dom.removeChild(oldChild);
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.dom.appendChild(newChild);
    }

    public boolean hasChildNodes() {
        return this.dom.hasChildNodes();
    }

    public Node cloneNode(boolean deep) {
        return this.dom.cloneNode(deep);
    }

    public void normalize() {
        this.dom.normalize();
    }

    public boolean isSupported(String feature, String version) {
        return this.dom.isSupported(feature, version);
    }

    public String getNamespaceURI() {
        return this.dom.getNamespaceURI();
    }

    public String getPrefix() {
        return this.dom.getPrefix();
    }

    public void setPrefix(String prefix) throws DOMException {
        this.dom.setPrefix(prefix);
    }

    public String getLocalName() {
        return this.dom.getLocalName();
    }

    public boolean hasAttributes() {
        return this.dom.hasAttributes();
    }

    public String getBaseURI() {
        return this.dom.getBaseURI();
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        return this.dom.compareDocumentPosition(other);
    }

    public String getTextContent() throws DOMException {
        return this.dom.getTextContent();
    }

    public void setTextContent(String textContent) throws DOMException {
        this.dom.setTextContent(textContent);
    }

    public boolean isSameNode(Node other) {
        return this.dom.isSameNode(other);
    }

    public String lookupPrefix(String namespaceURI) {
        return this.dom.lookupPrefix(namespaceURI);
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return this.dom.isDefaultNamespace(namespaceURI);
    }

    public String lookupNamespaceURI(String prefix) {
        return this.dom.lookupNamespaceURI(prefix);
    }

    public boolean isEqualNode(Node arg) {
        return this.dom.isEqualNode(arg);
    }

    public Object getFeature(String feature, String version) {
        return this.dom.getFeature(feature, version);
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.dom.setUserData(key, data, handler);
    }

    public Object getUserData(String key) {
        return this.dom.getUserData(key);
    }
}

