/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.TableColumn;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;

public class Main
extends JApplet
implements MouseListener,
DropTargetListener {
    private JTable table;
    private JScrollPane scrollPane;
    private JPanel rightPanel;
    private JButton add;
    private JButton remove;
    private JButton upload;
    private JButton help;
    private ImageIcon dropIcon;
    private ImageIcon dropIconUpload;
    private ImageIcon dropIconAdded;
    private TableData tabledata;
    private TableColumn sizeColumn;
    private File[] files;
    private JLabel progCompletion;
    private JLabel iconLabel;
    private JProgressBar progBar;
    private int sentBytes;
    private int totalBytes;
    private int buttonClicked;
    private int maxPixels;
    private int percentComplete;
    private int maxFileSize;
    private Color backgroundColour;
    private Color columnHeadColourBack;
    private Color columnHeadColourFore;
    private PostletLabels pLabels;
    private Vector failedFiles;
    private Vector uploadedFiles;
    private UploadManager upMan;
    private JFileChooser chooser;
    private PrintStream out = System.out;
    private boolean javascript;
    private URL endPageURL;
    private URL helpPageURL;
    private URL destinationURL;
    private URL dropImageURL;
    private URL dropImageUploadURL;
    private URL dropImageAddedURL;
    private boolean warnMessage;
    private boolean autoUpload;
    private boolean helpButton;
    private boolean failedFileMessage;
    private boolean addButton;
    private boolean removeButton;
    private boolean uploadButton;
    private String language;
    private String dropImage;
    private String dropImageAdded;
    private String dropImageUpload;
    private String proxy;
    private String fileToRemove;
    private int maxThreads;
    private String[] fileExtensions;
    private DataFlavor uriListFlavor;
    private JSObject jso;
    private static final String[] postletJS = new String[]{"postletStatus", "postletFinished", "postletFiles", "postletError"};
    public static final String postletVersion = "0.15";

    public void init() {
        System.out.println("POSTLET VERSION: 0.15");
        String date = "$Date: 2008-08-05 17:26:13 +0100 (Tue, 05 Aug 2008) $";
        System.out.println(date.substring(7, date.length() - 1));
        try {
            this.uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException cnfe) {
            this.errorMessage("No class found for DataFlavor");
        }
        try {
            this.jso = JSObject.getWindow((Applet)this);
        }
        catch (JSException njjse) {
            this.errorMessage("Unable to create JSO. Safari?");
        }
        this.javascript = false;
        JavascriptListener jsListen = new JavascriptListener(this);
        jsListen.start();
        this.buttonClicked = 0;
        this.percentComplete = 0;
        this.getParameters();
        this.layoutGui();
        this.createChooser();
        this.failedFiles = new Vector();
        this.uploadedFiles = new Vector();
    }

    private void createChooser() {
        this.chooser = new JFileChooser();
        this.progBar.setValue(0);
        if (this.fileExtensions != null) {
            UploaderFileFilter filter = new UploaderFileFilter();
            for (int i = 1; i < this.fileExtensions.length; ++i) {
                filter.addExtension(this.fileExtensions[i]);
            }
            filter.setDescription(this.fileExtensions[0]);
            this.chooser.addChoosableFileFilter(filter);
        } else {
            this.chooser.setFileFilter(this.chooser.getAcceptAllFileFilter());
        }
        this.chooser.setFileSelectionMode(2);
        this.chooser.setMultiSelectionEnabled(true);
        this.chooser.setDialogTitle(this.pLabels.getLabel(14));
    }

    private void layoutGui() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException exc) {
        }
        catch (IllegalAccessException exc) {
        }
        catch (ClassNotFoundException exc) {
        }
        catch (InstantiationException exc) {
            // empty catch block
        }
        Container pane = this.getContentPane();
        try {
            DropTarget dt = new DropTarget();
            dt.addDropTargetListener(this);
            pane.setDropTarget(dt);
        }
        catch (TooManyListenersException tmle) {
            this.errorMessage("Too many listeners to drop!");
        }
        this.tabledata = new TableData(this.pLabels.getLabel(0), this.pLabels.getLabel(1) + " -KB ");
        this.table = new JTable(this.tabledata);
        this.table.setColumnSelectionAllowed(false);
        this.sizeColumn = this.table.getColumn(this.pLabels.getLabel(1) + " -KB ");
        this.sizeColumn.setMaxWidth(100);
        this.table.getColumn(this.pLabels.getLabel(1) + " -KB ").setMinWidth(100);
        if (this.columnHeadColourBack != null && this.backgroundColour != null) {
            this.errorMessage("setting the tables colours");
            this.table.getTableHeader().setBackground(this.columnHeadColourBack);
            this.table.getTableHeader().setForeground(this.columnHeadColourFore);
            this.table.setBackground(this.backgroundColour);
        }
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (this.backgroundColour != null) {
            this.scrollPane.setBackground(this.backgroundColour);
        }
        this.scrollPane.getViewport().setBackground(Color.white);
        if (this.dropImageURL != null) {
            this.dropIcon = new ImageIcon(this.dropImageURL);
            this.iconLabel = new JLabel(this.dropIcon);
            pane.add((Component)this.iconLabel, "Center");
        } else {
            pane.add((Component)this.scrollPane, "Center");
        }
        if (this.dropImageUploadURL != null) {
            this.dropIconUpload = new ImageIcon(this.dropImageUploadURL);
        }
        if (this.dropImageAddedURL != null) {
            this.dropIconAdded = new ImageIcon(this.dropImageAddedURL);
        }
        this.errorMessage("Adding button");
        this.rightPanel = this.helpButton ? new JPanel(new GridLayout(4, 1, 10, 10)) : new JPanel(new GridLayout(3, 1, 10, 10));
        this.rightPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add = new JButton(this.pLabels.getLabel(6));
        if (this.addButton) {
            this.add.addMouseListener(this);
            this.rightPanel.add(this.add);
        }
        this.remove = new JButton(this.pLabels.getLabel(7));
        if (this.removeButton) {
            this.remove.addMouseListener(this);
            this.remove.setEnabled(false);
            this.rightPanel.add(this.remove);
        }
        this.upload = new JButton(this.pLabels.getLabel(8));
        if (this.uploadButton) {
            this.upload.addMouseListener(this);
            this.upload.setEnabled(false);
            this.rightPanel.add(this.upload);
        }
        this.help = new JButton(this.pLabels.getLabel(9));
        if (this.helpButton) {
            this.help.addMouseListener(this);
            this.rightPanel.add(this.help);
        }
        if (this.backgroundColour != null) {
            this.rightPanel.setBackground(this.backgroundColour);
        }
        if (this.addButton || this.removeButton || this.helpButton || this.uploadButton) {
            pane.add((Component)this.rightPanel, "East");
        }
        JPanel progPanel = new JPanel(new GridLayout(2, 1));
        progPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.progCompletion = new JLabel(this.pLabels.getLabel(10), 0);
        progPanel.add(this.progCompletion);
        this.progBar = new JProgressBar();
        progPanel.add(this.progBar);
        progPanel.setBorder(BorderFactory.createEmptyBorder(5, 25, 5, 25));
        if (this.backgroundColour != null) {
            pane.setBackground(this.backgroundColour);
            progPanel.setBackground(this.backgroundColour);
        }
        pane.add((Component)progPanel, "South");
        if (this.destinationURL == null) {
            this.add.setEnabled(false);
        }
    }

    protected void errorMessage(String message) {
        this.out.println("*** " + message + " ***");
    }

    private void getParameters() {
        URL codeBase;
        try {
            this.maxFileSize = Integer.parseInt(this.getParameter("maxfilesize"));
        }
        catch (NullPointerException nullMaxSize) {
            this.errorMessage("maxfilesize is null");
            this.maxFileSize = Integer.MAX_VALUE;
        }
        catch (NumberFormatException nfemaxfilesize) {
            this.errorMessage("maxfilesize is not a number");
            this.maxFileSize = Integer.MAX_VALUE;
        }
        try {
            this.proxy = this.getParameter("proxy");
            if (this.proxy.equals("") || this.proxy.equals(null) || this.proxy.toLowerCase().equals("false")) {
                this.proxy = "";
            }
        }
        catch (NullPointerException nullProxy) {
            this.proxy = "";
            this.errorMessage("proxy is null");
        }
        try {
            this.language = this.getParameter("language");
            if (this.language.equals("") || this.language.equals(null)) {
                this.language = "EN";
            }
        }
        catch (NullPointerException nullLang) {
            this.language = "EN";
            this.errorMessage("language is null");
        }
        this.pLabels = new PostletLabels(this.language, this.getCodeBase());
        try {
            this.destinationURL = new URL(this.getParameter("destination"));
        }
        catch (MalformedURLException malurlex) {
            this.errorMessage("Badly formed destination:###" + this.getParameter("destination") + "###");
            JOptionPane.showMessageDialog(null, "" + this.pLabels.getLabel(3), "" + this.pLabels.getLabel(5), 0);
        }
        catch (NullPointerException npe) {
            this.errorMessage("destination is null");
            JOptionPane.showMessageDialog(null, this.pLabels.getLabel(4), this.pLabels.getLabel(5), 0);
        }
        try {
            Integer bgci = new Integer(this.getParameter("backgroundcolour"));
            this.backgroundColour = new Color(bgci);
        }
        catch (NumberFormatException numfe) {
            this.errorMessage("background colour is not a number:###" + this.getParameter("backgroundcolour") + "###");
        }
        catch (NullPointerException nullred) {
            this.errorMessage("background colour is null");
        }
        try {
            Integer thfi = new Integer(this.getParameter("tableheadercolour"));
            this.columnHeadColourFore = new Color(thfi);
        }
        catch (NumberFormatException numfe) {
            this.errorMessage("table header colour is not a number:###" + this.getParameter("tableheadcolour") + "###");
        }
        catch (NullPointerException nullred) {
            this.errorMessage("table header colour is null");
        }
        try {
            Integer thbi = new Integer(this.getParameter("tableheaderbackgroundcolour"));
            this.columnHeadColourBack = new Color(thbi);
        }
        catch (NumberFormatException numfe) {
            this.errorMessage("table header back colour is not a number:###" + this.getParameter("tableheaderbackgroundcolour") + "###");
        }
        catch (NullPointerException nullred) {
            this.errorMessage("table header back colour is null");
        }
        try {
            this.fileExtensions = this.getParameter("fileextensions").split(",");
        }
        catch (NullPointerException nullfileexts) {
            this.errorMessage("file extensions is null");
        }
        try {
            this.warnMessage = this.getParameter("warnmessage").toLowerCase().equals("true");
        }
        catch (NullPointerException nullwarnmessage) {
            this.errorMessage("warnmessage is null");
            this.warnMessage = false;
        }
        try {
            this.autoUpload = this.getParameter("autoupload").toLowerCase().equals("true");
        }
        catch (NullPointerException nullwarnmessage) {
            this.errorMessage("autoUpload is null");
            this.autoUpload = false;
        }
        try {
            Integer maxts = new Integer(this.getParameter("maxthreads"));
            this.maxThreads = maxts;
        }
        catch (NullPointerException nullmaxthreads) {
            this.errorMessage("maxthreads is null");
        }
        catch (NumberFormatException nummaxthreads) {
            this.errorMessage("maxthread is not a number");
        }
        try {
            this.endPageURL = new URL(this.getParameter("endpage"));
        }
        catch (MalformedURLException malurlex) {
            this.errorMessage("endpage is badly formed:###" + this.getParameter("endpage") + "###");
        }
        catch (NullPointerException npe) {
            this.errorMessage("endpage is null");
        }
        try {
            this.helpPageURL = new URL(this.getParameter("helppage"));
        }
        catch (MalformedURLException malurlex) {
            this.errorMessage("helppage is badly formed:###" + this.getParameter("helppage") + "###");
        }
        catch (NullPointerException npe) {
            this.errorMessage("helppage is null");
        }
        try {
            this.helpButton = this.getParameter("helpbutton").toLowerCase().trim().equals("true");
        }
        catch (NullPointerException nullwarnmessage) {
            this.errorMessage("helpbutton is null");
            this.helpButton = false;
        }
        try {
            this.addButton = !this.getParameter("addbutton").toLowerCase().trim().equals("false");
        }
        catch (NullPointerException nullwarnmessage) {
            this.errorMessage("addbutton is null");
            this.addButton = true;
        }
        try {
            this.removeButton = !this.getParameter("removebutton").toLowerCase().trim().equals("false");
        }
        catch (NullPointerException nullwarnmessage) {
            this.errorMessage("removebutton is null");
            this.removeButton = true;
        }
        try {
            this.uploadButton = !this.getParameter("uploadbutton").toLowerCase().trim().equals("false");
        }
        catch (NullPointerException nullwarnmessage) {
            this.errorMessage("uploadbutton is null");
            this.uploadButton = true;
        }
        try {
            this.dropImage = this.getParameter("dropimage");
            if (this.dropImage != null) {
                this.dropImageURL = new URL(this.dropImage);
            }
        }
        catch (MalformedURLException urlexception) {
            try {
                codeBase = this.getCodeBase();
                this.dropImageURL = new URL(codeBase.getProtocol() + "://" + codeBase.getHost() + codeBase.getPath() + this.dropImage);
            }
            catch (MalformedURLException urlexception2) {
                this.errorMessage("dropimage is not a valid reference");
            }
        }
        try {
            this.dropImageUpload = this.getParameter("dropimageupload");
            if (this.dropImageUpload != null) {
                this.dropImageUploadURL = new URL(this.dropImageUpload);
            }
        }
        catch (MalformedURLException urlexception) {
            try {
                codeBase = this.getCodeBase();
                this.dropImageUploadURL = new URL(codeBase.getProtocol() + "://" + codeBase.getHost() + codeBase.getPath() + this.dropImageUpload);
            }
            catch (MalformedURLException urlexception2) {
                this.errorMessage("dropimageupload is not a valid reference");
            }
        }
        try {
            this.dropImageAdded = this.getParameter("dropimageadded");
            if (this.dropImageAdded != null) {
                this.dropImageAddedURL = new URL(this.dropImageAdded);
            }
        }
        catch (MalformedURLException urlexception) {
            try {
                codeBase = this.getCodeBase();
                this.dropImageAddedURL = new URL(codeBase.getProtocol() + "://" + codeBase.getHost() + codeBase.getPath() + this.dropImageAdded);
            }
            catch (MalformedURLException urlexception2) {
                this.errorMessage("dropimageupload is not a valid reference");
            }
        }
        try {
            this.failedFileMessage = this.getParameter("failedfilesmessage").toLowerCase().trim().equals("true");
        }
        catch (NullPointerException nullfailedfilemessage) {
            this.errorMessage("failedfilemessage is null");
            this.failedFileMessage = false;
        }
        try {
            Integer maxps = new Integer(this.getParameter("maxpixels"));
            this.maxPixels = maxps;
        }
        catch (NullPointerException nullmaxpixels) {
            this.errorMessage("maxpixels is null");
        }
        catch (NumberFormatException nummaxpixels) {
            this.errorMessage("maxpixels is not a number");
        }
    }

    private void removeClick() {
        if (this.table.getSelectedRowCount() > 0) {
            File[] fileTemp = new File[this.files.length - this.table.getSelectedRowCount()];
            int[] selectedRows = this.table.getSelectedRows();
            Arrays.sort(selectedRows);
            int k = 0;
            for (int i = 0; i < this.files.length; ++i) {
                if (Arrays.binarySearch(selectedRows, i) >= 0) continue;
                fileTemp[k] = this.files[i];
                ++k;
            }
            this.files = fileTemp;
            this.tableUpdate();
        }
        if (this.files.length == 0) {
            this.upload.setEnabled(false);
            this.remove.setEnabled(false);
        }
    }

    public void uploadClick() {
        if (this.files != null && this.files.length > 0) {
            if (this.warnMessage) {
                JOptionPane.showMessageDialog(null, this.pLabels.getLabel(11), this.pLabels.getLabel(12), 1);
            }
            this.add.setEnabled(false);
            this.remove.setEnabled(false);
            this.help.setEnabled(false);
            this.upload.setEnabled(false);
            if (this.dropImageURL != null && this.dropImageUploadURL != null) {
                this.iconLabel.setIcon(this.dropIconUpload);
                this.repaint();
            }
            this.sentBytes = 0;
            this.progBar.setMaximum(this.totalBytes);
            this.progBar.setMinimum(0);
            try {
                this.upMan = new UploadManager(this.files, this, this.destinationURL, this.maxThreads);
            }
            catch (NullPointerException npered) {
                this.upMan = new UploadManager(this.files, this, this.destinationURL);
            }
            this.upMan.start();
        }
    }

    protected synchronized void setProgress(int a) {
        if (this.totalBytes > 0) {
            this.sentBytes += a;
            this.progBar.setValue(this.sentBytes);
            if (this.sentBytes * 100 / this.totalBytes > this.percentComplete) {
                this.percentComplete = this.sentBytes * 100 / this.totalBytes;
                try {
                    this.jso.eval("try{" + postletJS[0] + "(" + this.percentComplete + ");}catch(e){;}");
                }
                catch (JSException jseps) {
                    this.errorMessage("Unable to send status to Javascript");
                }
                catch (NullPointerException npe) {
                    this.errorMessage("Unable to send status to Javascript");
                }
            }
            if (this.sentBytes >= this.totalBytes) {
                if (this.sentBytes == this.totalBytes) {
                    if (this.failedFiles.size() > 0 && this.failedFileMessage) {
                        String failedFilesString = "\r\n";
                        for (int i = 0; i < this.failedFiles.size(); ++i) {
                            File tempFile = (File)this.failedFiles.elementAt(i);
                            failedFilesString = failedFilesString + tempFile.getName() + "\r\n";
                        }
                        JOptionPane.showMessageDialog(null, this.pLabels.getLabel(16) + ":" + failedFilesString, this.pLabels.getLabel(5), 0);
                    }
                    this.progCompletion.setText(this.pLabels.getLabel(2));
                    if (this.endPageURL != null) {
                        this.errorMessage("Changing browser page");
                        this.getAppletContext().showDocument(this.endPageURL);
                    } else {
                        try {
                            this.errorMessage("Executing: " + postletJS[1] + "();");
                            this.jso.eval("try{" + postletJS[1] + "();}catch(e){;}");
                        }
                        catch (JSException jse) {
                            this.errorMessage("postletFinished, and End page unset");
                        }
                        catch (NullPointerException npe) {
                            this.errorMessage("postletFinished, and End page unset, and JS not executed");
                        }
                    }
                }
                this.totalBytes = 0;
                this.percentComplete = 0;
                this.progBar.setValue(0);
                this.files = new File[0];
                this.tableUpdate();
                this.add.setEnabled(true);
                this.help.setEnabled(true);
                if (this.dropImageURL != null && this.dropImageUploadURL != null) {
                    this.iconLabel.setIcon(this.dropIcon);
                }
                this.failedFiles.clear();
                this.uploadedFiles.clear();
                this.repaint();
            }
        }
    }

    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String p) {
        this.proxy = p;
    }

    public void addFailedFile(File f) {
        this.failedFiles.add(f);
    }

    public void addUploadedFile(File f) {
        this.uploadedFiles.add(f);
    }

    public int getMaxPixels() {
        return this.maxPixels;
    }

    public void setMaxPixels(int pixels) {
        this.maxPixels = pixels;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(int f) {
        this.maxFileSize = f;
    }

    private void tableUpdate() {
        int i;
        this.totalBytes = 0;
        String[] filenames = new String[this.files.length];
        int[] fileSize = new int[this.files.length];
        for (i = 0; i < this.files.length; ++i) {
            filenames[i] = this.files[i].getAbsolutePath();
            fileSize[i] = (int)this.files[i].length();
            this.totalBytes += (int)this.files[i].length();
        }
        String[][] rowData = new String[this.files.length][2];
        for (i = 0; i < this.files.length; ++i) {
            rowData[i][0] = this.files[i].getName();
            rowData[i][1] = "" + this.files[i].length();
        }
        this.tabledata.formatTable(rowData, i);
        this.sizeColumn.setMaxWidth(100);
        this.sizeColumn.setMinWidth(100);
        this.repaint();
    }

    public void addClick() {
        int returnVal = this.chooser.showOpenDialog(null);
        if (returnVal == 0) {
            int i;
            File[] tempFiles = this.chooser.getSelectedFiles();
            Vector<File> filesForUpload = new Vector<File>();
            for (i = 0; i < tempFiles.length; ++i) {
                if (tempFiles[i].isDirectory()) {
                    File[] subDirFiles = tempFiles[i].listFiles();
                    for (int j = 0; j < subDirFiles.length; ++j) {
                        if (!subDirFiles[j].isFile()) continue;
                        if (subDirFiles[j].length() < (long)this.maxFileSize) {
                            filesForUpload.add(subDirFiles[j]);
                            continue;
                        }
                        this.fileTooBig(subDirFiles[j]);
                    }
                    continue;
                }
                if (tempFiles[i].length() < (long)this.maxFileSize) {
                    filesForUpload.add(tempFiles[i]);
                    continue;
                }
                this.fileTooBig(tempFiles[i]);
            }
            if (this.files == null) {
                this.files = new File[0];
            }
            tempFiles = new File[filesForUpload.size() + this.files.length];
            for (i = 0; i < this.files.length; ++i) {
                tempFiles[i] = this.files[i];
            }
            for (i = 0; i < filesForUpload.size(); ++i) {
                tempFiles[i + this.files.length] = (File)filesForUpload.elementAt(i);
            }
            this.files = tempFiles;
            this.tableUpdate();
        }
        if (this.files != null && this.files.length > 0) {
            this.upload.setEnabled(true);
            this.remove.setEnabled(true);
            if (this.dropImageURL != null && this.dropImageAddedURL != null) {
                this.iconLabel.setIcon(this.dropIconAdded);
                this.repaint();
            }
            try {
                this.jso.eval("try{" + postletJS[2] + "('" + this.getFiles() + "');}catch(e){;}");
            }
            catch (JSException jsepf) {
                this.errorMessage("Unable to send info about files added");
            }
            catch (NullPointerException npe) {
                this.errorMessage("Unable to send info about files added");
            }
        }
        if (this.files != null && this.autoUpload) {
            this.uploadClick();
        }
        this.createChooser();
    }

    public void fileTooBig(File f) {
        this.errorMessage("file too big: " + f.getName() + " - " + f.length());
        if (this.warnMessage) {
            JOptionPane.showMessageDialog(null, "" + this.pLabels.getLabel(1) + " - " + f.getName(), "" + this.pLabels.getLabel(5), 0);
        }
        this.addFailedFile(f);
        try {
            this.jso.eval("try{" + postletJS[3] + "(0,'" + f.getName().replace("'", "`") + "');}catch(e){;}");
        }
        catch (JSException jsepf) {
            this.errorMessage("Unable to send info about 'file too big'");
        }
        catch (NullPointerException npe) {
            this.errorMessage("Unable to send info about 'file too big'");
        }
    }

    public void fileNotAllowed(File f) {
        this.errorMessage("file not allowed: " + f.getName());
        this.addFailedFile(f);
        try {
            this.jso.eval("try{" + postletJS[3] + "(1,'" + f.getName().replace("'", "`") + "');}catch(e){;}");
        }
        catch (JSException jsepf) {
            this.errorMessage("Unable to send info about 'file not allowed'");
        }
    }

    public void fileNotFound(File f) {
        this.errorMessage("file not found: " + f.getName());
        this.addFailedFile(f);
        try {
            this.jso.eval("try{" + postletJS[3] + "(2,'" + f.getName().replace("'", "`") + "');}catch(e){;}");
        }
        catch (JSException jsepf) {
            this.errorMessage("Unable to send info about 'file not found'");
        }
        catch (NullPointerException npe) {
            this.errorMessage("Unable to send info about 'file not found'");
        }
    }

    public void fileUploadFailed(File f) {
        this.errorMessage("file upload failed: " + f.getName());
        this.addFailedFile(f);
        try {
            this.jso.eval("try{" + postletJS[3] + "(3,'" + f.getName().replace("'", "`") + "');}catch(e){;}");
        }
        catch (JSException jsepf) {
            this.errorMessage("Unable to send info about 'file upload failed'");
        }
        catch (NullPointerException npe) {
            this.errorMessage("Unable to send info about 'file upload failed'");
        }
    }

    public void helpClick() {
        try {
            this.getAppletContext().showDocument(this.helpPageURL, "_blank");
        }
        catch (NullPointerException nohelppage) {
            try {
                this.getAppletContext().showDocument(new URL("http://www.postlet.com/help/"), "_blank");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public String getCookie() {
        try {
            String cookie = new String();
            cookie = (String)this.jso.eval("try{document.cookie;}catch(e){;}");
            this.errorMessage("Cookie is:###" + cookie + "###");
            return cookie;
        }
        catch (Exception e) {
            this.errorMessage("Failed to get cookie");
            return "";
        }
    }

    public void cancelUpload() {
        this.upMan.cancelUpload();
        this.errorMessage("Canceled upload");
        if (this.totalBytes > 0) {
            this.setProgress(this.totalBytes + 1);
        }
    }

    public String getFailedFiles() {
        if (this.failedFiles.size() > 0) {
            String failedFilesString = "";
            for (int i = 0; i < this.failedFiles.size(); ++i) {
                File tempFile = (File)this.failedFiles.elementAt(i);
                failedFilesString = failedFilesString + tempFile.getName() + "/";
            }
            return failedFilesString.replace("'", "`");
        }
        return null;
    }

    public String getFiles() {
        String fileString = "" + this.files.length;
        for (int i = 0; i < this.files.length; ++i) {
            fileString = fileString + "/" + this.files[i].getName();
        }
        return fileString.replace("'", "`");
    }

    public String getUploadedFiles() {
        if (this.uploadedFiles.size() > 0) {
            String uploadedFilesString = "";
            for (int i = 0; i < this.uploadedFiles.size(); ++i) {
                File tempFile = (File)this.uploadedFiles.elementAt(i);
                uploadedFilesString = uploadedFilesString + tempFile.getName() + "/";
            }
            return uploadedFilesString.replace("'", "`");
        }
        return null;
    }

    public void changedDestination(String destination) {
        try {
            this.destinationURL = new URL(destination);
        }
        catch (MalformedURLException malurlex) {
            this.errorMessage("Badly formed destination:###" + destination + "###");
            JOptionPane.showMessageDialog(null, "" + this.pLabels.getLabel(3), "" + this.pLabels.getLabel(5), 0);
        }
        catch (NullPointerException npe) {
            this.errorMessage("destination is null");
            JOptionPane.showMessageDialog(null, this.pLabels.getLabel(4), this.pLabels.getLabel(5), 0);
        }
    }

    protected void doRemoveFile(String number) {
        try {
            int fileNumber = Integer.parseInt(number);
            if (this.files.length > fileNumber && fileNumber > -1) {
                File[] fileTemp = new File[this.files.length - 1];
                int j = 0;
                for (int i = 0; i < this.files.length; ++i) {
                    if (i == fileNumber) continue;
                    fileTemp[j] = this.files[i];
                    ++j;
                }
                this.files = fileTemp;
                this.tableUpdate();
                if (this.files.length == 0) {
                    this.upload.setEnabled(false);
                    this.remove.setEnabled(false);
                }
            }
            try {
                this.jso.eval("try{" + postletJS[2] + "('" + this.getFiles() + "');}catch(e){;}");
            }
            catch (JSException jsepf) {
                this.errorMessage("Unable to send info about files added");
            }
            catch (NullPointerException npe) {
                this.errorMessage("Unable to send info about files added");
            }
        }
        catch (NumberFormatException nfe) {
            this.errorMessage("removeFile not a number");
        }
    }

    public void postletAdd() {
        this.buttonClicked = 0;
        this.javascript = true;
    }

    public void removeFile(String number) {
        this.buttonClicked = 3;
        this.fileToRemove = number;
        this.javascript = true;
    }

    public String getFileToRemove() {
        return this.fileToRemove;
    }

    public void postletUpload() {
        this.buttonClicked = 1;
        this.javascript = true;
    }

    public void postletCancel() {
        this.buttonClicked = 2;
        this.javascript = true;
    }

    public boolean getJavascriptStatus() {
        return this.javascript;
    }

    public void setJavascriptStatus() {
        this.javascript = false;
    }

    public boolean isUploadEnabled() {
        return this.upload.isEnabled();
    }

    public boolean isAddEnabled() {
        return this.add.isEnabled();
    }

    public boolean isRemoveEnabled() {
        return this.remove.isEnabled();
    }

    public int getButtonClicked() {
        return this.buttonClicked;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.add && this.add.isEnabled()) {
            this.addClick();
        }
        if (e.getSource() == this.upload && this.upload.isEnabled()) {
            this.uploadClick();
        }
        if (e.getSource() == this.remove && this.remove.isEnabled()) {
            this.removeClick();
        }
        if (e.getSource() == this.help && this.help.isEnabled()) {
            this.helpClick();
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        dtde.acceptDrop(3);
        Transferable trans = dtde.getTransferable();
        try {
            int j;
            DataFlavor[] dataFlavour = dtde.getCurrentDataFlavors();
            Vector<File> filesFromDrop = new Vector<File>();
            boolean filesFound = false;
            while (!filesFound) {
                for (int i = 0; i < dataFlavour.length; ++i) {
                    File tempFile;
                    if (dataFlavour[i].isFlavorJavaFileListType()) {
                        this.errorMessage("Windows D'n'D");
                        List listOfFiles = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
                        Iterator iter = listOfFiles.iterator();
                        while (iter.hasNext()) {
                            tempFile = (File)iter.next();
                            filesFromDrop.add(tempFile);
                        }
                        filesFound = true;
                        continue;
                    }
                    if (!dataFlavour[i].equals(this.uriListFlavor)) continue;
                    this.errorMessage("Linux (Mac?) D'n'D");
                    BufferedReader in = new BufferedReader(dataFlavour[i].getReaderForText(trans));
                    String line = in.readLine();
                    while (line != null && !line.equals("")) {
                        try {
                            tempFile = new File(new URI(line));
                            filesFromDrop.add(tempFile);
                        }
                        catch (URISyntaxException usee) {
                        }
                        catch (IllegalArgumentException iae) {
                            // empty catch block
                        }
                        line = in.readLine();
                    }
                    filesFound = true;
                }
            }
            Object[] tempFiles = new File[filesFromDrop.size()];
            filesFromDrop.copyInto(tempFiles);
            Vector<Object> filesForUpload = new Vector<Object>();
            for (j = 0; j < tempFiles.length; ++j) {
                if (((File)tempFiles[j]).isDirectory()) {
                    File[] subDirFiles = ((File)tempFiles[j]).listFiles();
                    for (int k = 0; k < subDirFiles.length; ++k) {
                        if (!subDirFiles[k].isFile()) continue;
                        filesForUpload.add(subDirFiles[k]);
                    }
                    continue;
                }
                filesForUpload.add(tempFiles[j]);
            }
            if (this.files == null) {
                this.files = new File[0];
            }
            tempFiles = new File[filesForUpload.size() + this.files.length];
            for (j = 0; j < this.files.length; ++j) {
                tempFiles[j] = this.files[j];
            }
            for (j = 0; j < filesForUpload.size(); ++j) {
                tempFiles[j + this.files.length] = (File)filesForUpload.elementAt(j);
            }
            this.files = tempFiles;
            this.tableUpdate();
            if (this.files != null && this.files.length > 0) {
                this.errorMessage("Enabling the upload and remove buttons");
                this.upload.setEnabled(true);
                this.remove.setEnabled(true);
            }
            if (this.files != null && this.autoUpload) {
                this.uploadClick();
            }
        }
        catch (UnsupportedFlavorException usfe) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        dtde.dropComplete(true);
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

