/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.browser.net.ProxyInfo;
import com.sun.java.browser.net.ProxyService;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class UploadThread
extends Thread {
    private File file;
    private Main main;
    private int attempts;
    private int finalByteSize;
    private static final String lotsHyphens = "---------------------------";
    private static final String lineEnd = "\r\n";
    private String header;
    private String footer;
    private String request;
    private String reply;
    private String afterContent;
    private InputStream fileStream;
    private URL url;
    private String boundary;
    private Socket sock;
    private boolean addPngToFileName;
    private boolean doUpload;

    public UploadThread(URL u, File f, Main m) throws IOException, UnknownHostException {
        this.url = u;
        this.file = f;
        this.main = m;
        this.attempts = 0;
        this.doUpload = true;
    }

    public void run() {
        try {
            this.upload();
        }
        catch (FileNotFoundException fnfe) {
            this.main.fileNotFound(this.file);
            this.main.setProgress((int)this.file.length());
        }
        catch (IOException ioe) {
            this.run();
            this.main.errorMessage("IOException: UploadThread");
        }
    }

    public void cancelUpload() {
        this.doUpload = false;
    }

    private void upload() throws FileNotFoundException, IOException {
        this.uploadFile();
        if (this.reply != null && this.reply.indexOf("POSTLET:NO") > 0) {
            if (this.reply.indexOf("POSTLET:RETRY") > 0) {
                this.reply = "";
                if (this.attempts < 3) {
                    this.main.setProgress(-((int)this.file.length()));
                    this.main.setProgress(this.finalByteSize);
                    ++this.attempts;
                    this.upload();
                } else {
                    this.main.fileUploadFailed(this.file);
                    this.main.setProgress(this.finalByteSize);
                }
            } else {
                if (this.reply.indexOf("POSTLET:FILE TYPE NOT ALLOWED") > 0) {
                    this.main.fileNotAllowed(this.file);
                } else {
                    this.main.fileUploadFailed(this.file);
                }
                this.attempts = 5;
                this.main.setProgress(this.finalByteSize);
            }
        } else {
            this.main.addUploadedFile(this.file);
            this.main.setProgress(this.finalByteSize);
        }
    }

    private synchronized void uploadFile() throws FileNotFoundException, IOException {
        this.setInputStream();
        this.sock = this.getSocket();
        this.setBoundary(40);
        this.setHeaderAndFooter();
        DataOutputStream output = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
        BufferedReader input = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
        output.writeBytes(this.request);
        try {
            output.write(this.header.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            this.main.errorMessage("Couldn't get header in UTF-8");
            output.writeBytes(this.header);
        }
        output.flush();
        ReadLine rl = new ReadLine(input, this);
        rl.start();
        try {
            this.wait(1000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        output.writeBytes(this.afterContent);
        boolean numBytes = false;
        if (this.file.length() > Integer.MAX_VALUE) {
            throw new IOException("*** FILE TOO BIG ***");
        }
        int maxBufferSize = 1024;
        int bytesAvailable = this.fileStream.available();
        int bufferSize = Math.min(bytesAvailable, maxBufferSize);
        this.finalByteSize = 0;
        byte[] buffer = new byte[bufferSize];
        int bytesRead = this.fileStream.read(buffer, 0, bufferSize);
        while (bytesAvailable > 0 && this.doUpload) {
            output.write(buffer, 0, bufferSize);
            if (bufferSize == maxBufferSize) {
                this.main.setProgress(bufferSize);
            } else {
                this.finalByteSize = bufferSize;
            }
            bytesAvailable = this.fileStream.available();
            bufferSize = Math.min(bytesAvailable, maxBufferSize);
            bytesRead = this.fileStream.read(buffer, 0, bufferSize);
        }
        if (this.doUpload) {
            output.writeBytes(this.footer);
            output.writeBytes(lineEnd);
            output.flush();
            try {
                this.wait(1000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            this.reply = rl.getRead();
            this.main.errorMessage("REPLY");
            this.main.errorMessage(this.reply);
            this.main.errorMessage("END REPLY");
        }
        input.close();
        output.close();
        this.sock.close();
    }

    private Socket getSocket() throws IOException, UnknownHostException {
        if (this.url.getProtocol().equalsIgnoreCase("https")) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                int port = this.url.getPort();
                if (this.url.getPort() > 0) {
                    return sc.getSocketFactory().createSocket(this.url.getHost(), this.url.getPort());
                }
                return sc.getSocketFactory().createSocket(this.url.getHost(), 443);
            }
            catch (Exception e) {}
        } else {
            Socket s;
            try {
                ProxyInfo[] info = ProxyService.getProxyInfo((URL)this.url);
                if (info != null && info.length > 0) {
                    String proxyHost = info[0].getHost();
                    int proxyPort = info[0].getPort();
                    this.main.errorMessage("PROXY = " + proxyHost + ":" + proxyPort);
                    return new Socket(proxyHost, proxyPort);
                }
            }
            catch (Exception ex) {
                this.main.errorMessage("could not retrieve proxy configuration, attempting direct connection.");
            }
            String proxyHost = System.getProperties().getProperty("deployment.proxy.http.host");
            String proxyPort = System.getProperties().getProperty("deployment.proxy.http.port");
            String proxyType = System.getProperties().getProperty("deployment.proxy.type");
            if (proxyHost == null || proxyType == null || proxyHost.equalsIgnoreCase("") || proxyType.equalsIgnoreCase("0") || proxyType.equalsIgnoreCase("2") || proxyType.equalsIgnoreCase("-1")) {
                if (!this.main.getProxy().equals("")) {
                    String[] proxyParts = this.main.getProxy().split(":");
                    try {
                        s = new Socket(proxyParts[0], Integer.parseInt(proxyParts[1]));
                        this.main.errorMessage("Proxy (parameter) - " + proxyParts[0] + ":" + proxyParts[1]);
                    }
                    catch (NumberFormatException badPort) {
                        this.main.errorMessage("bad proxy parameter");
                        s = this.url.getPort() > 0 ? new Socket(this.url.getHost(), this.url.getPort()) : new Socket(this.url.getHost(), 80);
                    }
                }
                s = this.url.getPort() > 0 ? new Socket(this.url.getHost(), this.url.getPort()) : new Socket(this.url.getHost(), 80);
            } else {
                this.main.errorMessage("Proxy (browser) - " + proxyHost + " - " + proxyPort + " - " + proxyType);
                try {
                    s = new Socket(proxyHost, Integer.parseInt(proxyPort));
                }
                catch (NumberFormatException badPort) {
                    this.main.errorMessage("bad proxy from browser");
                    s = this.url.getPort() > 0 ? new Socket(this.url.getHost(), this.url.getPort()) : new Socket(this.url.getHost(), 80);
                }
            }
            return s;
        }
        return null;
    }

    private void setInputStream() throws FileNotFoundException {
        block8: {
            String fileExt = this.file.getName();
            if (((fileExt = fileExt.substring(fileExt.lastIndexOf(".") + 1)).equalsIgnoreCase("gif") || fileExt.equalsIgnoreCase("jpg") || fileExt.equalsIgnoreCase("jpeg") || fileExt.equalsIgnoreCase("png")) && this.main.getMaxPixels() > 0) {
                try {
                    BufferedImage buf = ImageIO.read(this.file);
                    int currentPixels = buf.getWidth() * buf.getHeight();
                    int maxPixels = this.main.getMaxPixels();
                    if (currentPixels > maxPixels) {
                        double reduceBy = Math.sqrt(maxPixels) / Math.sqrt(currentPixels);
                        int newWidth = (int)Math.round((double)buf.getWidth() * reduceBy);
                        int newHeigth = (int)Math.round((double)buf.getHeight() * reduceBy);
                        BufferedImage bufFinal = new BufferedImage(newWidth, newHeigth, 1);
                        Graphics2D g = (Graphics2D)bufFinal.getGraphics();
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        g.drawImage(buf, 0, 0, newWidth, newHeigth, null);
                        g.dispose();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        if (fileExt.equalsIgnoreCase("jpg") || fileExt.equalsIgnoreCase("jpeg")) {
                            ImageIO.write((RenderedImage)bufFinal, "JPG", baos);
                        } else {
                            ImageIO.write((RenderedImage)bufFinal, "PNG", baos);
                            if (fileExt.equalsIgnoreCase("gif")) {
                                this.addPngToFileName = true;
                            }
                        }
                        this.main.setProgress((int)this.file.length() - baos.size());
                        this.fileStream = new ByteArrayInputStream(baos.toByteArray());
                        break block8;
                    }
                    this.fileStream = new FileInputStream(this.file);
                }
                catch (IOException e) {
                    this.fileStream = new FileInputStream(this.file);
                }
            } else {
                this.fileStream = new FileInputStream(this.file);
            }
        }
    }

    private void setBoundary(int length) {
        char[] alphabet = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        Random r = new Random();
        String boundaryString = "";
        for (int i = 0; i < length; ++i) {
            boundaryString = boundaryString + alphabet[r.nextInt(alphabet.length)];
        }
        this.boundary = boundaryString;
    }

    private void setHeaderAndFooter() throws IOException {
        this.header = new String();
        this.footer = new String();
        this.request = new String();
        this.afterContent = "-----------------------------" + this.boundary + lineEnd + "Content-Disposition: form-data; name=\"userfile\"; filename=\"" + this.file.getName();
        if (this.addPngToFileName) {
            this.afterContent = this.afterContent + ".png";
        }
        this.afterContent = this.afterContent + "\"\r\nContent-Type: application/octet-stream\r\n\r\n";
        this.footer = "\r\n-----------------------------" + this.boundary + "--" + lineEnd;
        this.request = "POST " + this.url.toExternalForm() + " HTTP/1.1" + lineEnd;
        this.header = this.header + "Host: " + this.url.getHost() + lineEnd;
        this.header = this.header + "User-Agent: Mozilla/5.0 (Java/Postlet; rv:" + "0.15" + ")" + lineEnd;
        this.header = this.header + "Accept: text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5\r\n";
        this.header = this.header + "Accept-Language: en-us,en;q=0.5\r\n";
        this.header = this.header + "Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7\r\n";
        String cookie = this.main.getCookie();
        if (cookie.length() > 0) {
            this.header = this.header + "Cookie: " + cookie + lineEnd;
        }
        this.header = this.header + "Connection: close\r\n";
        this.header = this.header + "Content-Type: multipart/form-data; boundary=---------------------------" + this.boundary + lineEnd;
        this.header = this.header + "Content-Length: ";
        this.header = this.header + "" + (this.fileStream.available() + this.afterContent.length() + this.footer.length()) + lineEnd + lineEnd;
    }
}

