/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.util;

import java.util.StringTokenizer;

public class VersionParser
implements Comparable {
    private String version;

    public VersionParser(String version) {
        this.version = version;
    }

    public static int compare(String v1, String v2) {
        int result = new VersionParser(v1).compareTo(new VersionParser(v2));
        return result;
    }

    public int compareTo(Object o) {
        VersionParser vp = (VersionParser)o;
        StringTokenizer left = new StringTokenizer(this.version, ".-_: ");
        StringTokenizer right = new StringTokenizer(vp.version, ".-_: ");
        int result = 0;
        while (result == 0) {
            if (!left.hasMoreTokens() && !right.hasMoreTokens()) {
                return 0;
            }
            if (!right.hasMoreTokens()) {
                return 1;
            }
            if (!left.hasMoreTokens()) {
                return -1;
            }
            result = VersionParser.compareTokens(left.nextToken(), right.nextToken());
        }
        return result;
    }

    private static int compareTokens(String left, String right) {
        int rightNumber;
        int leftNumber = VersionParser.getNumberPrefix(left);
        int result = leftNumber - (rightNumber = VersionParser.getNumberPrefix(right));
        if (result != 0) {
            return result;
        }
        return left.compareTo(right);
    }

    private static int getNumberPrefix(String s) {
        int i = 0;
        while (i < s.length() && s.charAt(i) >= '0' && s.charAt(i) <= '9') {
            ++i;
        }
        return i > 0 ? Integer.parseInt(s.substring(0, i)) : -1;
    }

    public String toString() {
        return this.version;
    }
}

