/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xnap.commons.util.UncaughtExceptionListener;

public class UncaughtExceptionManager
implements UncaughtExceptionListener {
    public static String[] DEFAULT_MANGLE_PREFIXES = new String[]{"java.lang.IndexOutOfBoundsException", "java.lang.ArrayIndexOutOfBoundsException", "java.lang.RuntimeException"};
    private static Log logger = LogFactory.getLog(UncaughtExceptionManager.class);
    private static UncaughtExceptionListener defaultHandler = new NullExceptionHandler();
    private HashSet<String> blacklist = new HashSet();
    private File blacklistFile;
    private Vector<UncaughtExceptionListener> listeners = new Vector();
    private String[] manglePrefixes;
    static /* synthetic */ Class class$0;

    private static String asHex(byte[] hash) {
        StringBuilder buf = new StringBuilder(hash.length * 2);
        int i = 0;
        while (i < hash.length) {
            if ((hash[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(hash[i] & 0xFF, 16));
            ++i;
        }
        return buf.toString();
    }

    public static String removeExceptionDescription(String trace, String prefix) {
        int i;
        if (trace.startsWith(String.valueOf(prefix) + ": ") && (i = trace.indexOf("\n")) != -1) {
            return String.valueOf(prefix) + trace.substring(i);
        }
        return trace;
    }

    public static UncaughtExceptionListener getDefaultHandler() {
        return defaultHandler;
    }

    public static void setDefaultHandler(UncaughtExceptionListener handler) {
        defaultHandler = handler == null ? new NullExceptionHandler() : handler;
    }

    public UncaughtExceptionManager(File blacklistFile, String[] manglePrefixes) {
        this.blacklistFile = blacklistFile;
        this.manglePrefixes = manglePrefixes;
        this.readBlackList();
        UncaughtExceptionManager.setDefaultHandler(this);
    }

    public UncaughtExceptionManager(File blacklistFile) {
        this(blacklistFile, DEFAULT_MANGLE_PREFIXES);
    }

    public UncaughtExceptionManager() {
        this(null, DEFAULT_MANGLE_PREFIXES);
    }

    public void addExceptionListener(UncaughtExceptionListener l) {
        this.listeners.add(l);
    }

    public synchronized void addToBlacklist(Throwable e) {
        this.blacklist.add(this.buildMD5Hash(e));
        this.writeBlacklist();
    }

    private String buildMD5Hash(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return UncaughtExceptionManager.asHex(md.digest(s.getBytes()));
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace(System.err);
            return "";
        }
    }

    private String buildMD5Hash(Throwable e) {
        return this.buildMD5Hash(this.toString(e));
    }

    private String encode(Object o) {
        try {
            if (o != null) {
                return URLEncoder.encode(o.toString(), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UTF-8 encoding not supported", e);
        }
        return "";
    }

    private boolean isBlacklisted(Throwable e) {
        return this.blacklist.contains(this.buildMD5Hash(e));
    }

    private void readBlackList() {
        if (this.blacklistFile == null) {
            return;
        }
        if (!this.blacklistFile.exists()) {
            return;
        }
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(this.blacklistFile);
                ObjectInputStream p = new ObjectInputStream(in);
                this.blacklist = (HashSet)p.readObject();
            }
            catch (Throwable e) {
                logger.debug("Could not read exception blacklist file: " + this.blacklistFile.getAbsolutePath(), e);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void removeExceptionListener(UncaughtExceptionListener l) {
        this.listeners.remove(l);
    }

    public void sendProblemReport(URL destination, Thread thread, Throwable throwable, String version, String plugin) throws IOException {
        Properties p = System.getProperties();
        StringBuffer report = new StringBuffer();
        report.append("version=" + this.encode(version));
        report.append("&plugin=" + this.encode(plugin));
        report.append("&locale=" + this.encode(Locale.getDefault()));
        report.append("&os_name=" + this.encode(p.get("os.name")));
        report.append("&os_version=" + this.encode(p.get("os.version")));
        report.append("&os_arch=" + this.encode(p.get("os.arch")));
        report.append("&java_vendor=" + this.encode(p.get("java.vendor")));
        report.append("&java_version=" + this.encode(p.get("java.version")));
        report.append("&stacktrace=" + this.encode(this.toString(throwable)));
        String hash = this.buildMD5Hash(report.toString());
        String problemHash = this.buildMD5Hash(throwable);
        report.append("&hash=" + this.encode(hash));
        report.append("&problem_hash=" + this.encode(problemHash));
        HttpURLConnection conn = (HttpURLConnection)destination.openConnection();
        try {
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.setUseCaches(false);
            conn.setAllowUserInteraction(false);
            PrintWriter out = new PrintWriter(conn.getOutputStream());
            out.println(report);
            out.flush();
            out.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            try {
                String s;
                while ((s = in.readLine()) != null) {
                    logger.debug("Received: " + s + "\n");
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            conn.disconnect();
        }
    }

    public String toString(Throwable e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(baos);
        e.printStackTrace(printWriter);
        printWriter.close();
        String trace = baos.toString();
        int i = 0;
        while (i < this.manglePrefixes.length) {
            trace = UncaughtExceptionManager.removeExceptionDescription(trace, this.manglePrefixes[i]);
            ++i;
        }
        return trace;
    }

    public synchronized void uncaughtException(Thread t, Throwable e) {
        if (this.isBlacklisted(e)) {
            logger.debug("Blacklisted uncaught exception occured!", e);
            return;
        }
        UncaughtExceptionListener[] l = this.listeners.toArray(new UncaughtExceptionListener[0]);
        if (l != null && l.length > 0) {
            int i = l.length - 1;
            while (i >= 0) {
                l[i].uncaughtException(t, e);
                --i;
            }
        } else {
            e.printStackTrace(System.err);
        }
    }

    private void writeBlacklist() {
        if (this.blacklistFile == null) {
            return;
        }
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(this.blacklistFile);
                ObjectOutputStream p = new ObjectOutputStream(out);
                p.writeObject(this.blacklist);
            }
            catch (IOException e) {
                logger.debug("Could not write exception blacklist file: " + this.blacklistFile.getAbsolutePath(), e);
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static class NullExceptionHandler
    implements UncaughtExceptionListener {
        NullExceptionHandler() {
        }

        public void uncaughtException(Thread t, Throwable e) {
        }
    }
}

