/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.util;

import org.xnap.commons.util.VersionParser;

public class SystemHelper {
    public static final boolean IS_MACOSX;
    public static final boolean IS_WINDOWS;
    public static final boolean IS_WINDOWS_XP;
    public static final boolean IS_JDK13_OR_SMALLER;

    static {
        String ver = System.getProperty("java.version", "");
        IS_JDK13_OR_SMALLER = VersionParser.compare(ver, "1.4.0") < 0;
        String os = System.getProperty("os.name").toLowerCase();
        IS_WINDOWS = os.indexOf("windows") != -1;
        IS_WINDOWS_XP = IS_WINDOWS && os.indexOf("xp") != -1;
        IS_MACOSX = os.indexOf("mac os x") != -1;
    }

    public static boolean hasMacOSXModalDialogBug() {
        if (IS_MACOSX) {
            String ver = System.getProperty("os.version", "");
            return VersionParser.compare(ver, "10.2.0") < 0;
        }
        return false;
    }

    public static boolean hasMacOSXToolTipsBug() {
        return IS_MACOSX ? IS_JDK13_OR_SMALLER : false;
    }
}

