/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.util;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringHelper {
    public static final String[] SIZES = new String[]{"B", "KB", "MB", "GB", "TB"};
    public static final String ALPHABET_LOWER = "abcdefghijklmnopqrstuvwxyz";
    public static final String ALPHABET_UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String NUMBERS_INT = "0123456789";
    public static final String NUMBERS_DECIMAL = "0123456789.";
    public static final String MONEY_USD = "$0123456789.";
    public static final String ALPHA_NUM = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public static final String EMAIL = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.@_-";
    public static final String HOST = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.";
    public static final String REGULAR_STRING = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.@_-[]?$%/\\(){}?????+-*,;.<>|_^?~#";
    public static final String ANYTHING = null;

    public static String firstToken(String text, String separator) {
        if (separator == null) {
            throw new IllegalArgumentException("Separator must not be null");
        }
        if (separator.length() == 0) {
            throw new IllegalArgumentException("Separator must not be empty");
        }
        int i = text.indexOf(separator);
        return i == -1 ? text : text.substring(0, i);
    }

    public static int indexOfDigit(String s) {
        int i = 0;
        while (i < s.length()) {
            if (Character.isDigit(s.charAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String lastPrefix(String text, String separator) {
        if (separator == null) {
            throw new IllegalArgumentException("Separator must not be null");
        }
        if (separator.length() == 0) {
            throw new IllegalArgumentException("Separator must not be empty");
        }
        int i = text.lastIndexOf(separator);
        return i == -1 ? text : text.substring(0, i);
    }

    public static String lastToken(String text, String separator) {
        if (separator == null) {
            throw new IllegalArgumentException("Separator must not be null");
        }
        if (separator.length() == 0) {
            throw new IllegalArgumentException("Separator must not be empty");
        }
        int i = text.lastIndexOf(separator);
        if (i < 0 || i == text.length() - 1) {
            return "";
        }
        return text.substring(i + separator.length(), text.length());
    }

    public static String randomString(int length) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < length) {
            sb.append((char)Math.round(Math.random() * 25.0 + 97.0));
            ++i;
        }
        return sb.toString();
    }

    public static String replaceAll(String s, String oldChars, String newChars) {
        int j;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while ((j = s.indexOf(oldChars, i)) != -1) {
            sb.append(s.substring(i, j));
            sb.append(newChars);
            i = j + oldChars.length();
        }
        sb.append(s.substring(i));
        return sb.toString();
    }

    public static String stripExtra(String s) {
        StringBuilder sb = new StringBuilder();
        boolean newWord = false;
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (Character.isLetter(chars[i])) {
                if (newWord) {
                    sb.append(" ");
                    newWord = false;
                }
                sb.append(chars[i]);
            } else {
                newWord = true;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String[] toArray(String value, String separators) {
        StringTokenizer st = new StringTokenizer(value, separators);
        String[] array = new String[st.countTokens()];
        int i = 0;
        while (i < array.length) {
            array[i] = st.nextToken();
            ++i;
        }
        return array;
    }

    public static String toFirstUpper(String value) {
        if (value.length() > 1) {
            return String.valueOf(Character.toUpperCase(value.charAt(0))) + value.substring(1);
        }
        return value.toUpperCase();
    }

    public static int[] toIntArray(String value, String separators) {
        StringTokenizer st = new StringTokenizer(value, separators);
        int[] array = new int[st.countTokens()];
        int i = 0;
        while (i < array.length) {
            try {
                array[i] = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
        return array;
    }

    public static List<String> toList(String value, String separators) {
        StringTokenizer st = new StringTokenizer(value, separators);
        LinkedList<String> list = new LinkedList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    public static String toString(byte[] data) {
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace(System.err);
            try {
                return new String(data, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e2) {
                e2.printStackTrace(System.err);
                return new String(data);
            }
        }
    }

    public static String toString(Collection c, String separator) {
        StringBuilder sb = new StringBuilder();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            sb.append(i.next().toString());
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String toString(int[] array, String separator) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            sb.append(array[i]);
            sb.append(separator);
            ++i;
        }
        return sb.toString();
    }

    public static String toString(String[] array, String separator) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            sb.append(array[i]);
            sb.append(separator);
            ++i;
        }
        return sb.toString();
    }

    public static String formatSize(long size) {
        int i = 0;
        while (i < SIZES.length - 1 && size >= 1024L) {
            size /= 1024L;
            ++i;
        }
        return String.format("%,d %s", size, SIZES[i]);
    }

    public static String formatLength(long i) {
        StringBuilder sb = new StringBuilder();
        long x = i / 3600L;
        if (x > 0L) {
            sb.append(x);
            sb.append(":");
        }
        if ((x = i % 3600L / 60L) < 10L) {
            sb.append("0");
        }
        sb.append(x);
        sb.append(":");
        x = i % 60L;
        if (x < 10L) {
            sb.append("0");
        }
        sb.append(x);
        return sb.toString();
    }

    public static final String pad(String text, int padding) {
        if (padding < 0) {
            throw new IllegalArgumentException();
        }
        if (padding == 0) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text.length() + padding * 2);
        StringHelper.append(sb, " ", padding);
        sb.append(text);
        StringHelper.append(sb, " ", padding);
        return sb.toString();
    }

    public static final String pad(String text, int lpadding, int rpadding) {
        if (lpadding < 0) {
            throw new IllegalArgumentException();
        }
        if (rpadding < 0) {
            throw new IllegalArgumentException();
        }
        if (lpadding == 0 && rpadding == 0) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text.length() + lpadding + rpadding);
        StringHelper.append(sb, " ", lpadding);
        sb.append(text);
        StringHelper.append(sb, " ", rpadding);
        return sb.toString();
    }

    private static final void append(StringBuilder sb, String text, int count) {
        int i = 0;
        while (i < count) {
            sb.append(text);
            ++i;
        }
    }

    public static final void append(StringBuffer sb, String text, int count) {
        int i = 0;
        while (i < count) {
            sb.append(text);
            ++i;
        }
    }
}

