/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.util;

import org.xnap.commons.util.UncaughtExceptionListener;

public class RootThreadGroup
extends ThreadGroup {
    private UncaughtExceptionListener listener;

    public RootThreadGroup(String name, UncaughtExceptionListener listener, boolean installAsAWTExceptionHandler) {
        super(name);
        this.listener = listener;
        if (installAsAWTExceptionHandler) {
            this.installAsAWTExceptionHandler();
        }
    }

    public RootThreadGroup(String name, UncaughtExceptionListener listener) {
        this(name, listener, true);
    }

    public void handle(Throwable e) {
        this.listener.uncaughtException(Thread.currentThread(), e);
    }

    public void installAsAWTExceptionHandler() {
        System.setProperty("sun.awt.exception.handler", "org.xnap.commons.util.AWTExceptionHandler");
    }

    public void uncaughtException(Thread t, Throwable e) {
        this.listener.uncaughtException(t, e);
    }
}

