/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.util;

import java.util.NoSuchElementException;

public class QuotedStringTokenizer {
    public static final String QUOTE = "\"";
    public static final char QUOTE_CHAR = '\"';
    int index;
    boolean returnSeparators;
    private String separators;
    private String text;
    private int maxIndex;

    public QuotedStringTokenizer(String text, String separators, boolean returnSeparators) {
        this.text = text;
        this.maxIndex = text.length() - 1;
        this.separators = separators;
        this.returnSeparators = returnSeparators;
    }

    public QuotedStringTokenizer(String text, String separators) {
        this(text, separators, false);
    }

    public QuotedStringTokenizer(String text) {
        this(text, " ", false);
    }

    public int countTokens() {
        Token token;
        int count = 0;
        int i = this.index;
        while ((token = this.nextToken(i)) != null) {
            ++count;
            i = token.nextIndex;
        }
        return count;
    }

    public boolean hasMoreTokens() {
        return this.nextToken(this.index) != null;
    }

    public String nextToken(String separators) {
        this.separators = separators;
        return this.nextToken();
    }

    public String nextToken() {
        Token token = this.nextToken(this.index);
        if (token != null) {
            this.index = token.nextIndex;
            return token.text;
        }
        throw new NoSuchElementException();
    }

    /*
     * Unable to fully structure code
     */
    protected Token nextToken(int index) {
        if (index > this.maxIndex) {
            return null;
        }
        if (this.returnSeparators && this.separators.indexOf(this.text.charAt(index)) != -1) {
            return new Token(this.text.substring(index, index + 1), index + 1);
        }
        i = index;
        inQuotes = false;
        token = new StringBuilder();
        while (i <= this.maxIndex && this.separators.indexOf(this.text.charAt(i)) != -1) {
            ++i;
        }
        if (i <= this.maxIndex) ** GOTO lbl26
        return null;
lbl-1000:
        // 1 sources

        {
            c = this.text.charAt(i);
            if (this.separators.indexOf(c) == -1) ** GOTO lbl20
            if (inQuotes) {
                token.append(c);
            } else {
                return new Token(token.toString(), i);
lbl20:
                // 1 sources

                if (c == '\"') {
                    inQuotes = inQuotes == false;
                } else {
                    token.append(c);
                }
            }
            ++i;
lbl26:
            // 2 sources

            ** while (i <= this.maxIndex)
        }
lbl27:
        // 1 sources

        return new Token(token.toString(), i);
    }

    class Token {
        String text;
        int nextIndex;

        Token(String text, int nextIndex) {
            this.text = text;
            this.nextIndex = nextIndex;
        }
    }
}

