/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.util;

public class Progress
implements Comparable {
    private long rate;
    private long size;
    private long transferred;

    public Progress(long size, long transferred) {
        if (transferred > size) {
            throw new IllegalArgumentException("transferred must not be greater than size");
        }
        this.size = size;
        this.transferred = transferred;
    }

    public Progress() {
        this(-1L, -1L);
    }

    public int compareTo(Object o) {
        return (int)(this.getPercent() - ((Progress)o).getPercent());
    }

    public double getPercent() {
        return this.size <= 0L || this.transferred <= 0L ? 0.0 : (double)(this.transferred * 100L) / (double)this.size;
    }

    public long getRate() {
        return this.rate;
    }

    public void setRate(long rate) {
        this.rate = rate;
    }

    public long getSize() {
        return this.size;
    }

    public long getTransferred() {
        return this.transferred;
    }
}

