/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.util;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortRange {
    public static final int MIN_PORT = 1;
    public static final int MAX_PORT = 65535;
    private Set<Integer> list = new LinkedHashSet<Integer>();

    public PortRange(int first, int last) {
        this.add(first, last);
    }

    public PortRange(String range) {
        this.add(range);
    }

    public PortRange() {
    }

    public void add(int first, int last) {
        if (first < 1 || first > 65535) {
            throw new IllegalArgumentException();
        }
        if (last < 1 || last > 65535) {
            throw new IllegalArgumentException();
        }
        if (first > last) {
            throw new IllegalArgumentException("first must be smaller than or equal to last (" + first + ">" + last + ")");
        }
        int i = first;
        while (i <= last) {
            this.list.add(i);
            ++i;
        }
    }

    public void add(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException();
        }
        this.list.add(new Integer(port));
    }

    public void add(String range) {
        StringTokenizer t = new StringTokenizer(range, ";");
        while (t.hasMoreTokens()) {
            String ports = t.nextToken().trim();
            if (ports.length() == 0) continue;
            try {
                if (ports.indexOf("-") != -1) {
                    StringTokenizer u = new StringTokenizer(ports, "-");
                    if (u.countTokens() != 2) continue;
                    this.add(Integer.parseInt(u.nextToken()), Integer.parseInt(u.nextToken()));
                    continue;
                }
                this.add(Integer.parseInt(ports));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public ServerSocket bindRandom() {
        Iterator<Integer> it = this.randomIterator();
        while (it.hasNext()) {
            try {
                return new ServerSocket(it.next());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean contains(int port) {
        return this.list.contains(new Integer(port));
    }

    public int getRandom(int defaultPort) {
        if (this.size() > 0) {
            ArrayList<Integer> copy = new ArrayList<Integer>(this.list);
            int index = new Random().nextInt(copy.size());
            return (Integer)copy.get(index);
        }
        return defaultPort;
    }

    public Iterator<Integer> iterator() {
        return this.list.iterator();
    }

    public Iterator<Integer> randomIterator() {
        ArrayList<Integer> copy = new ArrayList<Integer>(this.list);
        Collections.shuffle(copy);
        return copy.iterator();
    }

    public int size() {
        return this.list.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Integer> copy = new ArrayList<Integer>(this.list);
        Collections.sort(copy);
        int start = 0;
        int last = -1;
        Iterator it = copy.iterator();
        while (it.hasNext()) {
            int current = (Integer)it.next();
            if (last == -1) {
                start = current;
            } else if (current - last > 1) {
                sb.append(start);
                if (start != last) {
                    sb.append("-");
                    sb.append(last);
                }
                sb.append(";");
                start = current;
            }
            last = current;
        }
        if (last != -1) {
            sb.append(start);
            if (start != last) {
                sb.append("-");
                sb.append(last);
            }
            sb.append(";");
        }
        return sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
    }
}

