/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.util;

import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class NetHelper {
    private static final I18n i18n = I18nFactory.getI18n(NetHelper.class);
    private static final Log logger = LogFactory.getLog(NetHelper.class);
    static /* synthetic */ Class class$0;

    public static void enableSocksProxy(String host, int port) {
        logger.debug("Enabling socks proxy: " + host + ":" + port);
        System.getProperties().put("socksProxySet", "true");
        System.getProperties().put("socksProxyHost", host);
        System.getProperties().put("socksProxyPort", String.valueOf(port));
    }

    public static void disableSocksProxy() {
        logger.debug("Disabling socks proxy");
        System.getProperties().remove("socksProxySet");
        System.getProperties().remove("socksProxyHost");
        System.getProperties().remove("socksProxyPort");
    }

    public static void enableHttpProxy(String host, int port) {
        logger.debug("Enabling http proxy: " + host + ":" + port);
        System.getProperties().put("proxySet", "true");
        System.getProperties().put("proxyHost", host);
        System.getProperties().put("proxyPort", String.valueOf(port));
    }

    public static void disableHttpProxy() {
        logger.debug("Disabling http proxy");
        System.getProperties().remove("proxySet");
        System.getProperties().remove("proxyHost");
        System.getProperties().remove("proxyPort");
    }

    public static String getErrorMessage(IOException e) {
        String message = e.getLocalizedMessage();
        if (e instanceof ConnectException) {
            return i18n.tr("Connection refused");
        }
        if (e instanceof UnknownHostException) {
            return i18n.tr("Unknown host {0}", message != null ? message : "");
        }
        return i18n.tr("Error ({0})", message != null ? message : e.toString());
    }

    public static long ipToLongHiFirst(byte[] address) {
        if (address.length != 4) {
            throw new IllegalArgumentException("byte array must be of length 4");
        }
        long ipNum = 0L;
        long multiplier = 1L;
        int i = 3;
        while (i >= 0) {
            int byteVal = (address[i] + 256) % 256;
            ipNum += (long)byteVal * multiplier;
            multiplier *= 256L;
            --i;
        }
        return ipNum;
    }

    public static String toIPAddressLittleEndian(long ip) {
        StringBuilder sb = new StringBuilder(15);
        sb.append(ip & 0xFFL);
        sb.append(".");
        sb.append(ip >> 8 & 0xFFL);
        sb.append(".");
        sb.append(ip >> 16 & 0xFFL);
        sb.append(".");
        sb.append(ip >> 24 & 0xFFL);
        return sb.toString();
    }

    public static String toIPAddressBigEndian(long ip) {
        StringBuilder sb = new StringBuilder(15);
        sb.append(ip >> 24 & 0xFFL);
        sb.append(".");
        sb.append(ip >> 16 & 0xFFL);
        sb.append(".");
        sb.append(ip >> 8 & 0xFFL);
        sb.append(".");
        sb.append(ip & 0xFFL);
        return sb.toString();
    }
}

