/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xnap.commons.io.NullProgressMonitor;
import org.xnap.commons.io.ProgressMonitor;
import org.xnap.commons.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHelper {
    private static Log logger = LogFactory.getLog(FileHelper.class);
    static /* synthetic */ Class class$0;

    public static synchronized File createUnique(String pathname) throws IOException {
        logger.debug("FileHelper: creating unique: " + pathname);
        File f = new File(FileHelper.uniqueName(pathname));
        f.createNewFile();
        return f;
    }

    public static synchronized File createUnique(File parent, String child) throws IOException {
        if (parent.isDirectory() || parent.mkdirs()) {
            return FileHelper.createUnique(String.valueOf(parent.getAbsolutePath()) + File.separator + child);
        }
        throw new FileNotFoundException();
    }

    public static synchronized File moveUnique(File file, String path, String filename) throws IOException {
        String newFilename = String.valueOf(FileHelper.appendSeparator(path)) + filename;
        logger.debug("moveUnique new name: " + newFilename);
        if (newFilename.equals(file.getAbsolutePath())) {
            return file;
        }
        File p = new File(path);
        if (p.isDirectory() || p.mkdirs()) {
            File newFile = new File(FileHelper.uniqueName(newFilename));
            logger.debug("moveUnique new file: " + newFile);
            if (FileHelper.move(file, newFile)) {
                return newFile;
            }
            throw new FileNotFoundException("Could not rename " + file.getAbsolutePath() + " to " + newFile.getAbsolutePath());
        }
        throw new FileNotFoundException("Could not create " + p.getAbsolutePath());
    }

    public static synchronized File moveUnique(File file, String path) throws IOException {
        return FileHelper.moveUnique(file, path, file.getName());
    }

    public static boolean move(File source, File dest) throws IOException {
        if (!source.renameTo(dest)) {
            FileHelper.copy(source, dest);
            source.delete();
        }
        return true;
    }

    public static void copy(File source, File dest) throws IOException {
        FileHelper.copy(source, dest, (ProgressMonitor)NullProgressMonitor.MONITOR);
    }

    public static void copy(File source, File dest, ProgressMonitor monitor) throws IOException {
        FileInputStream in = new FileInputStream(source);
        monitor.setTotalSteps(source.length());
        try {
            FileHelper.copy(in, new FileOutputStream(dest), monitor);
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void copy(InputStream inStream, OutputStream outStream) throws IOException {
        FileHelper.copy(inStream, outStream, (ProgressMonitor)NullProgressMonitor.MONITOR);
    }

    public static void copy(InputStream inStream, OutputStream outStream, ProgressMonitor monitor) throws IOException {
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            int count;
            in = new BufferedInputStream(inStream);
            out = new BufferedOutputStream(outStream);
            byte[] buffer = new byte[524288];
            while (!monitor.isCancelled() && (count = in.read(buffer, 0, buffer.length)) != -1) {
                ((BufferedOutputStream)out).write(buffer, 0, count);
                monitor.work(count);
            }
            ((BufferedOutputStream)out).flush();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String extension(String filename) {
        return StringHelper.lastToken(filename, ".").toLowerCase();
    }

    public static String name(String filename) {
        int i = filename.lastIndexOf(".");
        return i < 1 ? filename : filename.substring(0, i);
    }

    public static String uniqueName(String filename) {
        return FileHelper.uniqueName(filename, "");
    }

    public static String uniqueName(String filename, String infix) {
        String extension = FileHelper.extension(filename);
        if (extension.length() > 0) {
            extension = "." + extension;
            filename = FileHelper.name(filename);
        }
        if (infix.length() > 0) {
            infix = "." + infix;
        }
        if (FileHelper.exists(String.valueOf(filename) + infix + extension)) {
            int i = 1;
            while (true) {
                if (!FileHelper.exists(String.valueOf(filename) + infix + "." + i + extension)) {
                    return String.valueOf(filename) + infix + "." + i + extension;
                }
                ++i;
            }
        }
        return String.valueOf(filename) + infix + extension;
    }

    public static boolean exists(String pathname) {
        return new File(pathname).exists();
    }

    public static final String getHomeDir(String appname, String subdir) throws IOException {
        String dir;
        File file;
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("user.home"));
        sb.append(File.separatorChar);
        if (appname != null && appname.length() > 0) {
            sb.append(".");
            sb.append(appname);
            sb.append(File.separatorChar);
        }
        if (subdir != null && subdir.length() > 0) {
            sb.append(subdir);
            sb.append(File.separatorChar);
        }
        if ((file = new File(dir = sb.toString())).isDirectory() || file.mkdirs()) {
            return dir;
        }
        throw new IOException("Could not create directory");
    }

    public static final String getHomeDir(String appname) throws IOException {
        return FileHelper.getHomeDir(appname, null);
    }

    public static String appendSeparator(String path) {
        if (path.length() > 0 && !path.endsWith(File.separator)) {
            return String.valueOf(path) + File.separator;
        }
        return path;
    }

    public static void shorten(File file, long bytes) throws IOException {
        RandomAccessFile f = new RandomAccessFile(file, "rw");
        try {
            f.setLength(Math.max(f.length() - bytes, 0L));
        }
        finally {
            try {
                f.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void writeProperties(File file, Properties props) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            props.store(out, "This file was automatically generated.");
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void readBinary(File file, Collection<Object> c) throws IOException {
        logger.debug("reading binary file: " + file);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream(file));
            int size = in.readInt();
            int i = 0;
            while (i < size) {
                try {
                    Object o = in.readObject();
                    if (o != null) {
                        c.add(o);
                    }
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    logger.warn("error while reading binary file", e);
                }
                ++i;
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String readText(File file) throws IOException {
        return FileHelper.readText(new FileInputStream(file));
    }

    public static String readText(InputStream inStream) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream));
        try {
            int count;
            StringBuilder sb = new StringBuilder();
            char[] buffer = new char[4096];
            while ((count = in.read(buffer, 0, buffer.length)) != -1) {
                sb.append(buffer, 0, count);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String[] readConfig(File file) throws IOException {
        return FileHelper.readConfig(new FileInputStream(file));
    }

    public static String[] readConfig(InputStream inStream) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream));
        try {
            String s;
            LinkedList<String> lines = new LinkedList<String>();
            while ((s = in.readLine()) != null) {
                if ((s = s.trim()).length() == 0 || s.startsWith("#")) continue;
                lines.add(s);
            }
            String[] stringArray = lines.toArray(new String[0]);
            return stringArray;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void writeBinary(File file, Collection c) throws IOException {
        logger.debug("writing " + c.size() + " items to binary file: " + file);
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(file));
            out.writeInt(c.size());
            Iterator i = c.iterator();
            while (i.hasNext()) {
                try {
                    out.writeObject(i.next());
                }
                catch (NotSerializableException e) {
                    logger.debug("Object not serializable", e);
                }
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void writeText(File file, String text) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        try {
            out.write(text);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }
}

