/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.settings;

import java.awt.Window;
import org.xnap.commons.settings.IntSetting;
import org.xnap.commons.settings.SettingResource;

public class WindowSettingDirector {
    private IntSetting xSetting;
    private IntSetting ySetting;
    private IntSetting widthSetting;
    private IntSetting heightSetting;

    public WindowSettingDirector(SettingResource backend, String key, int defaultX, int defaultY, int defaultWidth, int defaultHeight) {
        this.xSetting = new IntSetting(backend, String.valueOf(key) + ".x", defaultX);
        this.ySetting = new IntSetting(backend, String.valueOf(key) + ".y", defaultY);
        this.widthSetting = new IntSetting(backend, String.valueOf(key) + ".width", defaultWidth);
        this.heightSetting = new IntSetting(backend, String.valueOf(key) + ".height", defaultHeight);
    }

    public WindowSettingDirector(SettingResource backend, String key) {
        this(backend, key, 0, 0, 0, 0);
    }

    public void save(Window window) {
        this.xSetting.setValue(window.getX());
        this.ySetting.setValue(window.getY());
        this.widthSetting.setValue(window.getWidth());
        this.heightSetting.setValue(window.getHeight());
    }

    public void restore(Window window) {
        window.setLocation((Integer)this.xSetting.getValue(), (Integer)this.ySetting.getValue());
        window.setSize((Integer)this.widthSetting.getValue(), (Integer)this.heightSetting.getValue());
    }
}

