/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.settings;

import org.xnap.commons.gui.table.SortableModel;
import org.xnap.commons.gui.table.TableLayout;
import org.xnap.commons.gui.table.TableLayoutListener;
import org.xnap.commons.settings.BooleanSetting;
import org.xnap.commons.settings.EnumSetting;
import org.xnap.commons.settings.IntArraySetting;
import org.xnap.commons.settings.IntSetting;
import org.xnap.commons.settings.SettingResource;
import org.xnap.commons.settings.StringArraySetting;

public class TableSettingDirector
implements TableLayoutListener {
    private EnumSetting<SortableModel.Order> sortOrderSetting;
    private IntSetting sortedColumnSetting;
    private IntArraySetting columnWidthsSetting;
    private StringArraySetting visibleColumnsSetting;
    private BooleanSetting maintainSortOrderSetting;
    private TableLayout tableLayout;

    public TableSettingDirector(SettingResource backend, String key, TableLayout tableLayout) {
        this.setTableLayout(tableLayout);
        this.columnWidthsSetting = new IntArraySetting(backend, "table." + key + ".columnWidths", null);
        this.sortOrderSetting = new EnumSetting<SortableModel.Order>(backend, "table." + key + ".sortOrder", SortableModel.Order.UNSORTED);
        this.sortedColumnSetting = new IntSetting(backend, "table." + key + ".sortedColumn", -1);
        this.visibleColumnsSetting = new StringArraySetting(backend, "table." + key + ".visibleColumns", new String[0]);
        this.maintainSortOrderSetting = new BooleanSetting(backend, "table." + key + ".maintainSortOrder", false);
    }

    public TableSettingDirector(SettingResource backend, String key) {
        this(backend, key, null);
    }

    public TableSettingDirector setDefaults(String[] visibleColumns) {
        this.visibleColumnsSetting.setDefaultValue(visibleColumns);
        return this;
    }

    public void setTableLayout(TableLayout tableLayout) {
        if (this.tableLayout != null) {
            this.tableLayout.removeTableLayoutListener(this);
        }
        this.tableLayout = tableLayout;
        if (this.tableLayout != null) {
            this.tableLayout.addTableLayoutListener(this);
        }
    }

    public void restore(TableLayout tableLayout) {
        int column;
        Integer[] columnWidths;
        int i = 0;
        while (i < tableLayout.getColumnCount()) {
            tableLayout.setColumnVisible(i, false);
            ++i;
        }
        String[] visibleColumns = (String[])this.visibleColumnsSetting.getValue();
        tableLayout.setAllColumnsVisible(false);
        boolean visible = false;
        int i2 = 0;
        while (i2 < visibleColumns.length) {
            int index = tableLayout.getColumnIndex(visibleColumns[i2]);
            if (index != -1) {
                tableLayout.setColumnVisible(index, true);
                visible = true;
            }
            ++i2;
        }
        if (!visible && tableLayout.getColumnCount() > 0) {
            tableLayout.setColumnVisible(0, true);
        }
        if ((columnWidths = (Integer[])this.columnWidthsSetting.getValue()) != null) {
            int i3 = 0;
            while (i3 < columnWidths.length && i3 < tableLayout.getColumnCount()) {
                tableLayout.getColumnAt(i3).setPreferredWidth(columnWidths[i3]);
                tableLayout.getColumnAt(i3).setWidth(columnWidths[i3]);
                ++i3;
            }
        }
        if ((column = ((Integer)this.sortedColumnSetting.getValue()).intValue()) >= 0 && column < tableLayout.getColumnCount()) {
            tableLayout.sortByColumn((Integer)this.sortedColumnSetting.getValue(), (SortableModel.Order)((Object)this.sortOrderSetting.getValue()), false);
        }
        tableLayout.setMaintainSortOrder((Boolean)this.maintainSortOrderSetting.getValue());
    }

    public void restore() {
        this.restore(this.tableLayout);
    }

    public void save(TableLayout tableLayout) {
        Integer[] widths = new Integer[tableLayout.getColumnCount()];
        boolean visibleColumnsCount = false;
        int i = 0;
        while (i < widths.length) {
            widths[i] = tableLayout.getColumnAt(i).getWidth();
            ++i;
        }
        this.columnWidthsSetting.setValue(widths);
        String[] visibleColumns = new String[tableLayout.getVisibleColumnsCount()];
        int i2 = 0;
        while (i2 < visibleColumns.length) {
            visibleColumns[i2] = tableLayout.getTable().getColumnModel().getColumn(i2).getIdentifier().toString();
            ++i2;
        }
        this.visibleColumnsSetting.setValue(visibleColumns);
        this.sortOrderSetting.setValue(tableLayout.getSortOrder());
        this.sortedColumnSetting.setValue(tableLayout.getSortedColumn());
        this.maintainSortOrderSetting.setValue(tableLayout.getMaintainSortOrder());
    }

    public void save() {
        this.save(this.tableLayout);
    }

    public void columnLayoutChanged() {
        this.save();
    }

    public void sortedColumnChanged() {
        this.save();
    }

    public void columnOrderChanged() {
        this.save();
    }

    public void columnNameChanged(int index, String newName) {
    }

    public void columnVisibilityChanged(int index, boolean visible) {
        this.save();
    }

    public void maintainSortOrderChanged(boolean newValue) {
    }
}

