/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.settings;

import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;
import org.xnap.commons.settings.Validator;

public class StringValidator
implements Validator {
    private static final I18n i18n = I18nFactory.getI18n(StringValidator.class);
    public static final StringValidator EMAIL = new StringValidator("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.@_-", 1);
    public static final StringValidator REGULAR_STRING = new StringValidator("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.@_-[]?$%/\\(){}?????+-*,;.<>|_^?~#", 1);
    private String validChars;
    private int minLength;
    static /* synthetic */ Class class$0;

    public StringValidator(String validChars, int minLength) {
        this.validChars = validChars;
        this.minLength = minLength;
    }

    public StringValidator(String validChars) {
        this(validChars, 0);
    }

    public StringValidator() {
        this(null);
    }

    public void validate(String value) {
        if (value == null) {
            throw new IllegalArgumentException(i18n.tr("Value must not be null"));
        }
        if (value.length() < this.minLength) {
            throw new IllegalArgumentException(i18n.tr("Value is too short"));
        }
        if (this.validChars != null) {
            int i = 0;
            while (i < value.length()) {
                if (this.validChars.indexOf(value.charAt(i)) == -1) {
                    throw new IllegalArgumentException(i18n.tr("Invalid character"));
                }
                ++i;
            }
        }
    }
}

