/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.settings;

import org.xnap.commons.settings.AbstractSetting;
import org.xnap.commons.settings.SettingResource;
import org.xnap.commons.settings.Validator;
import org.xnap.commons.util.QuotedStringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringArraySetting
extends AbstractSetting<String[]> {
    public StringArraySetting(SettingResource backend, String key, String[] defaultValue, Validator validator) {
        super(backend, key, defaultValue, validator);
    }

    public StringArraySetting(SettingResource backend, String key, String[] defaultValue) {
        super(backend, key, defaultValue, null);
    }

    @Override
    protected String[] fromString(String value) {
        QuotedStringTokenizer t = new QuotedStringTokenizer(value, ";");
        String[] values = new String[t.countTokens()];
        int i = 0;
        while (i < values.length) {
            values[i] = t.nextToken();
            ++i;
        }
        return values;
    }

    @Override
    protected String toString(String[] value) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < value.length) {
            sb.append("\"");
            sb.append(value[i]);
            sb.append("\"");
            sb.append(";");
            ++i;
        }
        return sb.toString();
    }
}

