/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.settings;

import java.awt.Window;
import javax.swing.JSplitPane;
import org.xnap.commons.gui.table.TableLayout;
import org.xnap.commons.settings.IntSetting;
import org.xnap.commons.settings.SettingResource;
import org.xnap.commons.settings.TableSettingDirector;
import org.xnap.commons.settings.WindowSettingDirector;

public class SettingStore {
    private SettingResource backStore;

    public SettingStore(SettingResource backStore) {
        this.backStore = backStore;
    }

    public SettingResource getBackStore() {
        return this.backStore;
    }

    public void saveSplitPane(String key, JSplitPane splitPane) {
        new IntSetting(this.getBackStore(), key, 0).setValue(splitPane.getDividerLocation());
    }

    public void saveWindow(String key, Window window) {
        new WindowSettingDirector(this.getBackStore(), key).save(window);
    }

    public void saveTable(String key, TableLayout tableLayout) {
        new TableSettingDirector(this.getBackStore(), key).save(tableLayout);
    }

    public void restoreSplitPane(String key, int defaultDividerLocation, JSplitPane splitPane) {
        splitPane.setDividerLocation((Integer)new IntSetting(this.getBackStore(), key, (Integer)defaultDividerLocation, 0).getValue());
    }

    public void restoreWindow(String key, int defaultX, int defaultY, int defaultWidth, int defaultHeight, Window window) {
        new WindowSettingDirector(this.getBackStore(), key, defaultX, defaultY, defaultWidth, defaultHeight).restore(window);
    }

    public void restoreTable(String key, String[] defaultColumns, TableLayout tableLayout) {
        new TableSettingDirector(this.backStore, key).setDefaults(defaultColumns).restore(tableLayout);
    }
}

