/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.settings;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.xnap.commons.settings.AbstractSetting;
import org.xnap.commons.settings.SettingResource;
import org.xnap.commons.settings.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableSetting<T extends Serializable>
extends AbstractSetting<T> {
    public SerializableSetting(SettingResource backend, String key, T defaultValue, Validator validator) {
        super(backend, key, defaultValue, validator);
    }

    public SerializableSetting(SettingResource backend, String key, T defaultValue) {
        super(backend, key, defaultValue, null);
    }

    @Override
    protected T fromString(String value) {
        ByteArrayInputStream buffer = new ByteArrayInputStream(this.toByteArray(value));
        try {
            ObjectInputStream in = new ObjectInputStream(buffer);
            return (T)((Serializable)in.readObject());
        }
        catch (IOException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String toString(T value) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(buffer);
            out.writeObject(value);
            String string = this.toString(buffer.toByteArray());
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not serialize value");
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    private String toString(byte[] array) {
        char[] chars = new char[array.length];
        int i = 0;
        while (i < chars.length) {
            chars[i] = (char)array[i];
            ++i;
        }
        return new String(chars);
    }

    private byte[] toByteArray(String s) {
        char[] chars = s.toCharArray();
        byte[] bytes = new byte[chars.length];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)chars[i];
            ++i;
        }
        return bytes;
    }
}

