/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.settings;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xnap.commons.settings.SettingResource;

public class PropertyResource
implements SettingResource {
    protected static Log logger = LogFactory.getLog(PropertyResource.class);
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    protected boolean changedFlag = false;
    protected int version;
    protected int oldVersion = -1;
    protected String namespace;
    protected Properties properties = new Properties();
    static /* synthetic */ Class class$0;

    public PropertyResource(int version, String namespace) {
        this.version = version;
        this.namespace = namespace == null || namespace.length() == 0 ? "" : (!namespace.endsWith(".") ? String.valueOf(namespace) + "." : namespace);
    }

    public PropertyResource() {
        this(0, "");
    }

    public void load(File prefsFile) throws IOException {
        logger.info("Reading settings from " + prefsFile);
        FileInputStream in = new FileInputStream(prefsFile);
        try {
            this.properties.load(in);
            try {
                this.oldVersion = Integer.parseInt(this.properties.getProperty("props.ver", "-1"));
            }
            catch (NumberFormatException e) {
                this.oldVersion = -1;
            }
            if (this.oldVersion != -1 && this.oldVersion < this.getVersion()) {
                logger.debug("converting from version " + this.oldVersion + " to " + this.getVersion());
                this.convert(this.oldVersion);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    public boolean store(File prefsFile) throws IOException {
        if (!this.changedFlag) {
            logger.info("nothing changed, not writing " + prefsFile);
            return true;
        }
        logger.info("writing " + prefsFile);
        FileOutputStream out = new FileOutputStream(prefsFile);
        try {
            this.properties.put("props.ver", String.valueOf(this.version));
            this.properties.store(out, "This file was automatically generated.");
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        this.changedFlag = false;
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyResource)) {
            return false;
        }
        PropertyResource r = (PropertyResource)o;
        return this.version == r.version && this.namespace.equals(r.namespace) && this.properties.equals(r.properties);
    }

    public int getOldVersion() {
        return this.oldVersion;
    }

    public int getVersion() {
        return this.version;
    }

    protected void convert(int oldVersion) {
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChange.addPropertyChangeListener(l);
    }

    public synchronized void addPropertyChangeListener(String key, PropertyChangeListener l) {
        this.propertyChange.addPropertyChangeListener(key, l);
    }

    public void firePropertyChange(String key, Object oldValue, Object newValue) {
        int i = key.lastIndexOf(".");
        if (key.length() > i + 1) {
            key = key.substring(i + 1);
        }
        this.propertyChange.firePropertyChange(key, oldValue, newValue);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChange.removePropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(String key, PropertyChangeListener l) {
        this.propertyChange.removePropertyChangeListener(key, l);
    }

    public String get(String key, String defaultValue) {
        return this.properties.getProperty(String.valueOf(this.namespace) + key, defaultValue);
    }

    public void put(String key, String newValue) {
        this.properties.setProperty(String.valueOf(this.namespace) + key, newValue);
        this.changedFlag = true;
    }

    public synchronized void remove(String key) {
        this.properties.remove(String.valueOf(this.namespace) + key);
        this.changedFlag = true;
    }

    public synchronized void renameProperty(String oldKey, String newKey) {
        Object oldValue;
        String value = this.properties.getProperty(oldKey, null);
        if (value != null && (oldValue = this.properties.remove(oldKey)) != null) {
            this.properties.setProperty(newKey, value);
            this.changedFlag = true;
        }
    }
}

