/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.settings;

import java.util.StringTokenizer;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;
import org.xnap.commons.settings.Validator;

public class PortRangeValidator
implements Validator {
    private static final I18n i18n = I18nFactory.getI18n(PortRangeValidator.class);
    public static final PortRangeValidator DEFAULT = new PortRangeValidator();
    private int min;
    private int max;
    private boolean valid;
    static /* synthetic */ Class class$0;

    public PortRangeValidator(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public PortRangeValidator() {
        this(1, 65535);
    }

    public void validate(String value) {
        this.valid = false;
        StringTokenizer t = new StringTokenizer(value, ";");
        while (t.hasMoreTokens()) {
            String ports = t.nextToken().trim();
            if (ports.length() == 0) continue;
            try {
                if (ports.indexOf("-") != -1) {
                    StringTokenizer u = new StringTokenizer(ports, "-");
                    if (u.countTokens() == 2) {
                        int i = Integer.parseInt(u.nextToken());
                        int j = Integer.parseInt(u.nextToken());
                        this.check(i);
                        this.check(j);
                        this.valid |= i <= j;
                        continue;
                    }
                    throw new IllegalArgumentException(i18n.tr("Malformed range."));
                }
                this.check(Integer.parseInt(ports));
                this.valid = true;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(i18n.tr("Malformed number."));
            }
        }
        if (!this.valid) {
            throw new IllegalArgumentException(i18n.tr("No port given."));
        }
    }

    public void check(int i) {
        if (i < this.min || i > this.max) {
            throw new IllegalArgumentException(i18n.tr("Port out of range {0}.", "(" + this.min + " - " + this.max + ")"));
        }
    }
}

