/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.settings;

import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import org.xnap.commons.settings.AbstractSetting;
import org.xnap.commons.settings.SettingResource;
import org.xnap.commons.settings.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStrokeSetting
extends AbstractSetting<KeyStroke> {
    public KeyStrokeSetting(SettingResource backend, String key, KeyStroke defaultValue, Validator validator) {
        super(backend, key, defaultValue, validator);
    }

    public KeyStrokeSetting(SettingResource backend, String key, KeyStroke defaultValue) {
        super(backend, key, defaultValue, null);
    }

    @Override
    protected KeyStroke fromString(String value) {
        StringTokenizer t = new StringTokenizer(value, ";");
        if (t.countTokens() >= 3) {
            try {
                int keyCode = Integer.parseInt(t.nextToken());
                int modifiers = Integer.parseInt(t.nextToken());
                Character character = new Character(t.nextToken().charAt(0));
                return keyCode == 0 ? KeyStroke.getKeyStroke(character, modifiers) : KeyStroke.getKeyStroke(keyCode, modifiers);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected String toString(KeyStroke value) {
        KeyStroke keystroke = value;
        StringBuilder sb = new StringBuilder();
        sb.append(keystroke.getKeyCode());
        sb.append(";");
        sb.append(keystroke.getModifiers());
        sb.append(";");
        sb.append(keystroke.getKeyChar());
        return sb.toString();
    }
}

