/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.settings;

import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;
import org.xnap.commons.settings.Validator;

public class IntValidator
implements Validator {
    private static I18n i18n = I18nFactory.getI18n(IntValidator.class);
    private int min;
    private int max;
    static /* synthetic */ Class class$0;

    public IntValidator(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("Min must not be greater than max (" + min + " > " + max + ")");
        }
        this.min = min;
        this.max = max;
    }

    public IntValidator(int min) {
        this(min, Integer.MAX_VALUE);
    }

    public IntValidator() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public void validate(String value) {
        if (value == null) {
            throw new IllegalArgumentException(i18n.tr("Value must not be null"));
        }
        int i = Integer.parseInt(value);
        if (i < this.min || i > this.max) {
            throw new IllegalArgumentException(i18n.tr("Value out of range."));
        }
    }
}

