/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.settings;

import org.xnap.commons.settings.AbstractSetting;
import org.xnap.commons.settings.IntValidator;
import org.xnap.commons.settings.SettingResource;
import org.xnap.commons.settings.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntSetting
extends AbstractSetting<Integer> {
    public IntSetting(SettingResource backend, String key, Integer defaultValue, int min, int max) {
        super(backend, key, defaultValue, new IntValidator(min, max));
    }

    public IntSetting(SettingResource backend, String key, Integer defaultValue, int min) {
        super(backend, key, defaultValue, new IntValidator(min));
    }

    public IntSetting(SettingResource backend, String key, Integer defaultValue, Validator validator) {
        super(backend, key, defaultValue, validator);
    }

    public IntSetting(SettingResource backend, String key, Integer defaultValue) {
        super(backend, key, defaultValue, null);
    }

    @Override
    protected Integer fromString(String value) {
        try {
            return new Integer(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    protected String toString(Integer value) {
        return value.toString();
    }
}

