/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.settings;

import java.util.StringTokenizer;
import org.xnap.commons.settings.AbstractSetting;
import org.xnap.commons.settings.SettingResource;
import org.xnap.commons.settings.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntArraySetting
extends AbstractSetting<Integer[]> {
    public IntArraySetting(SettingResource backend, String key, Integer[] defaultValue, Validator validator) {
        super(backend, key, defaultValue, validator);
    }

    public IntArraySetting(SettingResource backend, String key, Integer[] defaultValue) {
        super(backend, key, defaultValue, null);
    }

    @Override
    protected Integer[] fromString(String value) {
        StringTokenizer t = new StringTokenizer(value, ";");
        try {
            Integer[] values = new Integer[t.countTokens()];
            int i = 0;
            while (i < values.length) {
                values[i] = new Integer(t.nextToken());
                ++i;
            }
            return values;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    protected String toString(Integer[] value) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < value.length) {
            sb.append(value[i]);
            sb.append(";");
            ++i;
        }
        return sb.toString();
    }
}

