/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.settings;

import java.awt.Font;
import java.util.StringTokenizer;
import org.xnap.commons.settings.AbstractSetting;
import org.xnap.commons.settings.SettingResource;
import org.xnap.commons.settings.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontSetting
extends AbstractSetting<Font> {
    public FontSetting(SettingResource backend, String key, Font defaultValue, Validator validator) {
        super(backend, key, defaultValue, validator);
    }

    public FontSetting(SettingResource backend, String key, Font defaultValue) {
        super(backend, key, defaultValue, null);
    }

    @Override
    protected Font fromString(String value) {
        StringTokenizer t = new StringTokenizer(value, ";");
        if (t.countTokens() >= 3) {
            try {
                String name = t.nextToken();
                int style = Integer.parseInt(t.nextToken());
                int size = Integer.parseInt(t.nextToken());
                return new Font(name, style, size);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected String toString(Font value) {
        Font font = value;
        StringBuilder sb = new StringBuilder();
        sb.append(font.getName());
        sb.append(";");
        sb.append(font.getStyle());
        sb.append(";");
        sb.append(font.getSize());
        return sb.toString();
    }
}

