/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.settings;

import org.xnap.commons.settings.AbstractSetting;
import org.xnap.commons.settings.SettingResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumSetting<T extends Enum<T>>
extends AbstractSetting<T> {
    private Class<T> clazz;

    public EnumSetting(SettingResource backend, String key, T defaultValue) {
        super(backend, key, defaultValue, null);
        if (this.getDefaultValue() == null) {
            throw new IllegalArgumentException("defaultValue may not be null");
        }
        this.clazz = ((Enum)defaultValue).getDeclaringClass();
    }

    public EnumSetting(SettingResource backend, String key, Class<T> clazz) {
        super(backend, key, null, null);
        this.clazz = clazz;
    }

    public Class<T> getEnumClass() {
        return this.clazz;
    }

    @Override
    protected T fromString(String value) {
        try {
            return Enum.valueOf(this.clazz, value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    protected String toString(T value) {
        return ((Enum)value).name();
    }
}

