/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.settings;

import org.xnap.commons.gui.completion.Completion;
import org.xnap.commons.gui.completion.CompletionMode;
import org.xnap.commons.gui.completion.DefaultCompletionModel;
import org.xnap.commons.settings.ClassNameSetting;
import org.xnap.commons.settings.SettingResource;
import org.xnap.commons.settings.StringArraySetting;

public class CompletionSettingDirector {
    private ClassNameSetting<CompletionMode> modeSetting;
    private StringArraySetting dataSetting;

    public CompletionSettingDirector(SettingResource backstore, String key) {
        this.modeSetting = new ClassNameSetting<Object>(backstore, "completion." + key + ".mode", null);
        this.dataSetting = new StringArraySetting(backstore, "completion." + key + ".data", null);
    }

    public void save(Completion completion) {
        if (!(completion.getModel() instanceof DefaultCompletionModel)) {
            throw new IllegalArgumentException("completion.getModel() must inherit DefaultCompletionModel");
        }
        this.modeSetting.setValue(completion.getMode());
        DefaultCompletionModel model = (DefaultCompletionModel)completion.getModel();
        Object[] objectData = model.toArray();
        String[] data = new String[objectData.length];
        int i = 0;
        while (i < objectData.length) {
            data[i] = objectData[i].toString();
            ++i;
        }
        this.dataSetting.setValue(data);
    }

    public void restore(Completion completion) {
        Object[] data;
        if (!(completion.getModel() instanceof DefaultCompletionModel)) {
            throw new IllegalArgumentException("completion.getModel() must inherit DefaultCompletionModel");
        }
        CompletionMode mode = (CompletionMode)this.modeSetting.getValue();
        if (mode != null) {
            completion.setMode(mode);
        }
        if ((data = (String[])this.dataSetting.getValue()) != null) {
            DefaultCompletionModel model = (DefaultCompletionModel)completion.getModel();
            model.insert(data);
        }
    }
}

