/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.settings;

import java.beans.PropertyChangeListener;
import java.util.Arrays;
import org.xnap.commons.settings.PropertyResource;
import org.xnap.commons.settings.Setting;
import org.xnap.commons.settings.SettingResource;
import org.xnap.commons.settings.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSetting<T>
implements Setting<T> {
    public static final String ARRAY_SEPARATOR = ";";
    protected SettingResource backstore;
    private String key;
    private Validator validator;
    private T defaultValue;

    public AbstractSetting(SettingResource backstore, String key, T defaultValue, Validator validator) {
        this.backstore = backstore;
        this.key = key;
        this.defaultValue = defaultValue;
        this.validator = validator;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.backstore.addPropertyChangeListener(this.getKey(), l);
    }

    public static boolean areObjectsEqual(Object obj1, Object obj2) {
        return obj1 != null ? obj1.equals(obj2) : obj1 == obj2;
    }

    public static boolean areObjectsEqual(Object[] obj1, Object[] obj2) {
        return obj1 != null ? obj2 == null : Arrays.equals(obj1, obj2);
    }

    protected abstract T fromString(String var1);

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    public SettingResource getProperties() {
        return this.backstore;
    }

    @Override
    public T getValue() {
        T value = null;
        String s = this.backstore.get(this.getKey(), null);
        if (s != null) {
            value = this.fromString(s);
        }
        return value != null ? value : (T)this.defaultValue;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.backstore.removePropertyChangeListener(this.getKey(), l);
    }

    @Override
    public void revert() {
        this.setValue(this.defaultValue);
    }

    protected void setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setProperties(PropertyResource properties) {
        this.backstore = properties;
    }

    @Override
    public void setValue(T newValue) {
        T oldValue = this.getValue();
        if (!AbstractSetting.areObjectsEqual(newValue, oldValue)) {
            if (newValue == null || AbstractSetting.areObjectsEqual(newValue, this.defaultValue)) {
                this.backstore.remove(this.getKey());
            } else {
                String stringValue = this.toString(newValue);
                if (this.validator != null) {
                    this.validator.validate(stringValue);
                }
                this.backstore.put(this.getKey(), stringValue);
            }
            this.backstore.firePropertyChange(this.getKey(), oldValue, newValue);
        }
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    protected abstract String toString(T var1);
}

