/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.io;

import java.awt.Component;
import org.xnap.commons.io.ProgressMonitor;

public class SubTaskProgressMonitor
implements ProgressMonitor {
    private ProgressMonitor monitor;
    private int workedAmount;
    private int totalAmount;
    private long totalSteps;
    private boolean done;
    private long value;

    public SubTaskProgressMonitor(ProgressMonitor monitor, int amount, long totalSteps) {
        if (monitor == null) {
            throw new IllegalArgumentException();
        }
        if (amount < 0) {
            throw new IllegalArgumentException("amount may not be less than 0");
        }
        this.monitor = monitor;
        this.totalAmount = amount;
        this.setTotalSteps(totalSteps);
    }

    public long getValue() {
        return this.value;
    }

    public void setTotalSteps(long totalSteps) {
        if (totalSteps < 0L) {
            throw new IllegalArgumentException("totalSteps may not be less than 0");
        }
        if (this.workedAmount > 0) {
            throw new IllegalStateException("totalSteps may not be changed after work() or setValue() has been called");
        }
        this.totalSteps = totalSteps;
    }

    public void setValue(long value) {
        if (this.done) {
            throw new IllegalStateException("monitor is already done");
        }
        if (value > this.totalSteps) {
            throw new IllegalArgumentException("value may not exceed totalSteps (" + value + " > " + this.totalSteps + ")");
        }
        if (this.value == value) {
            return;
        }
        if (value < this.value) {
            throw new IllegalArgumentException("value may not decrease (" + value + " < " + this.value + ")");
        }
        this.value = value;
        double percent = (double)value / (double)this.totalSteps;
        int newAmount = (int)(percent * (double)this.totalAmount);
        if (newAmount > this.workedAmount) {
            this.monitor.work(newAmount - this.workedAmount);
            this.workedAmount += newAmount - this.workedAmount;
        }
    }

    public void work(long amount) {
        this.setValue(this.value + amount);
    }

    public void done() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.monitor.work(this.totalAmount - this.workedAmount);
    }

    public boolean isCancelled() {
        return this.monitor.isCancelled();
    }

    public void setCancelEnabled(boolean enabled) {
        this.monitor.setCancelEnabled(enabled);
    }

    public void setText(String text) {
        this.monitor.setText(text);
    }

    public Component getComponent() {
        return this.monitor.getComponent();
    }
}

