/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.io;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.xnap.commons.gui.ProgressDialog;
import org.xnap.commons.io.Job;
import org.xnap.commons.io.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExecutor {
    public static <T> Callable<T> callable(final Job<T> job, final ProgressMonitor monitor) {
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                return job.run(monitor);
            }
        };
    }

    public static <T> T run(String title, Job<T> job) throws Exception {
        ProgressDialog dialog = new ProgressDialog();
        dialog.setTitle(title);
        return JobExecutor.run(dialog, job);
    }

    public static <T> T run(JDialog owner, String title, Job<T> job) throws Exception {
        ProgressDialog dialog = new ProgressDialog(owner);
        dialog.setLocationRelativeTo(owner);
        dialog.setTitle(title);
        return JobExecutor.run(dialog, job);
    }

    public static <T> T run(JFrame owner, String title, Job<T> job) throws Exception {
        ProgressDialog dialog = new ProgressDialog(owner);
        dialog.setLocationRelativeTo(owner);
        dialog.setTitle(title);
        return JobExecutor.run(dialog, job);
    }

    private static <T> T run(final ProgressDialog dialog, final Job<T> job) throws Exception {
        final Object[] retSuccess = new Object[1];
        final Throwable[] ret = new Exception[1];
        Runnable runner = new Runnable(){

            public void run() {
                try {
                    retSuccess[0] = job.run(dialog);
                }
                catch (Throwable e) {
                    ret[0] = e;
                }
                SwingUtilities.invokeLater(new Runnable(this, dialog){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ ProgressDialog val$dialog;
                    {
                        this.this$1 = var1_1;
                        this.val$dialog = progressDialog;
                    }

                    public void run() {
                        this.val$dialog.done();
                    }
                });
            }
        };
        Thread t = new Thread(runner, "Job");
        t.start();
        dialog.setModal(true);
        dialog.showDialog();
        if (ret[0] != null) {
            if (ret[0] instanceof Exception) {
                throw (Exception)ret[0];
            }
            throw new InvocationTargetException(ret[0]);
        }
        return (T)retSuccess[0];
    }
}

