/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.io;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class FileExtensionFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private List<String> extensions = new ArrayList<String>();
    private String description;

    public FileExtensionFilter(String description, String extension) {
        this.description = description;
        this.extensions.add(extension);
    }

    public FileExtensionFilter(String description, String[] extensions) {
        this.description = description;
        this.extensions.addAll((Collection<String>)Arrays.asList(extensions));
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String name = file.getName();
        for (String extension : this.extensions) {
            if (!name.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }
}

