/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.i18n;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.LocaleChangeEvent;
import org.xnap.commons.i18n.LocaleChangeListener;

public class I18nManager {
    private static I18nManager instance = new I18nManager();
    List i18ns = new ArrayList();
    List localeChangeListeners = new ArrayList();
    static /* synthetic */ Class class$org$xnap$commons$i18n$I18nFactory;

    private I18nManager() {
    }

    public static I18nManager getInstance() {
        return instance;
    }

    public void add(I18n i18n) {
        this.i18ns.add(i18n);
    }

    public void setDefaultLocale(Locale locale) {
        Locale.setDefault(locale);
        Iterator it = this.i18ns.iterator();
        while (it.hasNext()) {
            I18n i18n = (I18n)it.next();
            i18n.setLocale(locale);
        }
        this.fireLocaleChangedEvent(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocaleChangeListener(LocaleChangeListener listener) {
        List list = this.localeChangeListeners;
        synchronized (list) {
            this.localeChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWeakLocaleChangeListener(LocaleChangeListener listener) {
        List list = this.localeChangeListeners;
        synchronized (list) {
            this.localeChangeListeners.add(new WeakLocaleChangeListener(listener));
        }
    }

    public void remove(I18n i18n) {
        this.i18ns.remove(i18n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocaleChangeListener(LocaleChangeListener listener) {
        List list = this.localeChangeListeners;
        synchronized (list) {
            this.localeChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireLocaleChangedEvent(Locale newLocale) {
        LocaleChangeListener[] listeners;
        List list = this.localeChangeListeners;
        synchronized (list) {
            listeners = this.localeChangeListeners.toArray(new LocaleChangeListener[0]);
        }
        if (listeners.length > 0) {
            LocaleChangeEvent event = new LocaleChangeEvent(class$org$xnap$commons$i18n$I18nFactory == null ? (class$org$xnap$commons$i18n$I18nFactory = I18nManager.class$("org.xnap.commons.i18n.I18nFactory")) : class$org$xnap$commons$i18n$I18nFactory, newLocale);
            for (int i = listeners.length - 1; i >= 0; --i) {
                listeners[i].localeChanged(event);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class WeakLocaleChangeListener
    implements LocaleChangeListener {
        private WeakReference reference;

        public WeakLocaleChangeListener(LocaleChangeListener listener) {
            this.reference = new WeakReference<LocaleChangeListener>(listener);
        }

        public void localeChanged(LocaleChangeEvent event) {
            Object listener = this.reference.get();
            if (listener != null) {
                ((LocaleChangeListener)listener).localeChanged(event);
            } else {
                I18nManager.getInstance().removeLocaleChangeListener(this);
            }
        }
    }
}

