/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.wizard;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.xnap.commons.gui.Builder;
import org.xnap.commons.gui.DefaultDialog;
import org.xnap.commons.gui.action.AbstractXNapAction;
import org.xnap.commons.gui.wizard.WizardDialogListener;
import org.xnap.commons.gui.wizard.WizardPage;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class WizardDialog
extends DefaultDialog {
    private static final I18n i18n = I18nFactory.getI18n(WizardDialog.class);
    private JLabel titleLabel;
    private JLabel iconLabel;
    private JLabel descriptionLabel;
    private JPanel pagePanel;
    private CardLayout pageCardLayout;
    private List<WizardPage> pages = new LinkedList<WizardPage>();
    private int selectedIndex = -1;
    private AbstractButton nextButton;
    private AbstractButton finishButton;
    private PreviousAction previousAction = new PreviousAction();
    private NextAction nextAction = new NextAction();
    private FinishAction finishAction = new FinishAction();
    private List<WizardDialogListener> listeners = new ArrayList<WizardDialogListener>();
    static /* synthetic */ Class class$0;

    public WizardDialog(int buttons) {
        super(buttons);
        this.initialize();
    }

    public WizardDialog(Dialog owner, int buttons) {
        super(owner, buttons);
        this.initialize();
    }

    public WizardDialog(Frame owner, int buttons) {
        super(owner, buttons);
        this.initialize();
    }

    public WizardDialog() {
        super(BUTTON_CANCEL);
        this.initialize();
    }

    public WizardDialog(Dialog owner) {
        super(owner, BUTTON_CANCEL);
        this.initialize();
    }

    public WizardDialog(Frame owner) {
        super(owner, BUTTON_CANCEL);
        this.initialize();
    }

    private void initialize() {
        JPanel jpTop = new JPanel(new BorderLayout());
        jpTop.setBackground(Color.white);
        jpTop.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)jpTop, "North");
        JPanel jpTitle = new JPanel(new BorderLayout());
        jpTitle.setBackground(Color.white);
        jpTop.add((Component)jpTitle, "Center");
        this.titleLabel = new JLabel(" ");
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.titleLabel.setFont(new Font("Dialog", 1, 16));
        this.titleLabel.setForeground(Color.black);
        jpTitle.add((Component)this.titleLabel, "North");
        this.descriptionLabel = new JLabel(" ");
        this.descriptionLabel.setBackground(Color.white);
        this.descriptionLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.descriptionLabel.setForeground(Color.black);
        jpTitle.add((Component)this.descriptionLabel, "Center");
        this.iconLabel = new JLabel();
        this.iconLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jpTop.add((Component)this.iconLabel, "East");
        this.pageCardLayout = new CardLayout();
        this.pagePanel = new JPanel();
        this.pagePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.pagePanel.setLayout(this.pageCardLayout);
        JPanel jpButtons = this.getButtonPanel();
        jpButtons.add((Component)Builder.createButton(this.previousAction), 0);
        this.nextButton = Builder.createButton(this.nextAction);
        this.nextButton.setHorizontalTextPosition(2);
        jpButtons.add((Component)this.nextButton, 1);
        this.finishButton = Builder.createButton(this.finishAction);
        jpButtons.add((Component)this.finishButton, 2);
        this.setMainComponent(this.pagePanel);
        this.setSize(640, 480);
    }

    public void addPage(WizardPage page, String identifier) {
        this.pages.add(page);
        this.pagePanel.add((Component)page.getPanel(), identifier);
        if (this.selectedIndex == -1) {
            this.selectedIndex = 0;
        }
        this.updateHeader();
    }

    public void addPage(int index, WizardPage page, String identifier) {
        this.pages.add(index, page);
        this.pagePanel.add((Component)page.getPanel(), identifier);
        if (this.selectedIndex == -1) {
            this.selectedIndex = 0;
        } else if (index <= this.selectedIndex) {
            ++this.selectedIndex;
        }
        this.updateHeader();
    }

    public void addWizardDialogListener(WizardDialogListener listener) {
        this.listeners.add(listener);
    }

    public void finish() {
        boolean canClose = true;
        for (WizardPage page : this.pages) {
            canClose &= page.apply();
        }
        if (canClose) {
            this.isOkay = true;
            this.close();
        }
    }

    public Action getFinishAction() {
        return this.finishAction;
    }

    public Action getNextAction() {
        return this.nextAction;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public WizardPage getSelectedPage() {
        return this.pages.get(this.getSelectedIndex());
    }

    protected void firePageChaned(WizardPage oldPage, WizardPage newPage) {
        WizardDialogListener[] array = this.listeners.toArray(new WizardDialogListener[0]);
        int i = array.length - 1;
        while (i >= 0) {
            array[i].pageChanged(oldPage, newPage);
            --i;
        }
    }

    public void removePage(WizardPage page) {
        int index = this.pages.indexOf(page);
        if (index == -1) {
            return;
        }
        this.pagePanel.remove(page.getPanel());
        this.pages.remove(index);
        if (index <= this.selectedIndex) {
            --this.selectedIndex;
        }
        if (this.selectedIndex == -1) {
            this.clearHeader();
        } else {
            this.updateHeader();
        }
    }

    public void removeWizardDialogListener(WizardDialogListener listener) {
        this.listeners.remove(listener);
    }

    private void updateActions() {
        this.previousAction.setEnabled(this.selectedIndex > 0);
        this.nextAction.setEnabled(this.selectedIndex < this.pages.size() - 1);
        if (this.nextAction.isEnabled()) {
            this.nextButton.requestFocus();
        } else {
            this.finishButton.requestFocus();
        }
    }

    public void showNextPage() {
        if (this.selectedIndex == this.pages.size() - 1) {
            throw new IllegalStateException("no more pages");
        }
        WizardPage oldPage = this.getSelectedPage();
        this.pageCardLayout.next(this.pagePanel);
        ++this.selectedIndex;
        this.updateHeader();
        this.firePageChaned(oldPage, this.getSelectedPage());
    }

    public void showPreviousPage() {
        if (this.selectedIndex <= 0) {
            throw new IllegalStateException("no more pages");
        }
        WizardPage oldPage = this.getSelectedPage();
        this.pageCardLayout.previous(this.pagePanel);
        --this.selectedIndex;
        this.updateHeader();
        this.firePageChaned(oldPage, this.getSelectedPage());
    }

    private void updateHeader() {
        WizardPage panel = this.getSelectedPage();
        this.titleLabel.setText(panel.getTitle());
        this.iconLabel.setIcon(panel.getIcon());
        this.descriptionLabel.setText(panel.getDescription());
        this.updateActions();
    }

    private void clearHeader() {
        this.titleLabel.setText(" ");
        this.iconLabel.setIcon(null);
        this.descriptionLabel.setText(" ");
    }

    public class PreviousAction
    extends AbstractXNapAction {
        public PreviousAction() {
            this.putValue("Name", i18n.tr("Previous"));
            this.putValue("XNapIcon", "1leftarrow.png");
        }

        public void actionPerformed(ActionEvent event) {
            WizardDialog.this.showPreviousPage();
        }
    }

    public class NextAction
    extends AbstractXNapAction {
        public NextAction() {
            this.putValue("Name", i18n.tr("Next"));
            this.putValue("XNapIcon", "1rightarrow.png");
        }

        public void actionPerformed(ActionEvent event) {
            WizardDialog.this.showNextPage();
        }
    }

    public class FinishAction
    extends AbstractXNapAction {
        public FinishAction() {
            this.putValue("Name", i18n.tr("Finish"));
        }

        public void actionPerformed(ActionEvent event) {
            WizardDialog.this.finish();
        }
    }

    protected class PContainer
    extends JPanel {
        Dimension maxDim = new Dimension(0, 0);

        protected PContainer() {
        }

        public void add(Component comp, Object constraints) {
            Dimension d = comp.getPreferredSize();
            if (d.height > this.maxDim.height) {
                this.maxDim.height = d.height;
            }
            if (d.width > this.maxDim.width) {
                this.maxDim.width = d.width;
            }
            super.add(comp, constraints);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.maxDim.width + 10, this.maxDim.height + 30);
        }
    }
}

